/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.packet;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class FluidParticlePacket {
    private final BlockState blockState;
    private final BlockPos blockPos;

    public FluidParticlePacket(BlockState blockState, BlockPos blockPos) {
        this.blockState = blockState;
        this.blockPos = blockPos;
    }

    void encode(PacketBuffer buffer) {
        buffer.writeInt(Block.func_196246_j((BlockState)this.blockState));
        buffer.func_179255_a(this.blockPos);
    }

    FluidParticlePacket(PacketBuffer buffer) {
        this.blockState = Block.func_196257_b((int)buffer.readInt());
        this.blockPos = buffer.func_179259_c();
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Optional optionalWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)context.get()).getDirection().getReceptionSide());
            optionalWorld.filter(ClientWorld.class::isInstance).ifPresent(world -> this.blockState.func_204520_s().func_215676_d((IBlockReader)world, this.blockPos).func_197755_b((p_228348_3_, p_228348_5_, p_228348_7_, p_228348_9_, p_228348_11_, p_228348_13_) -> {
                double d1 = Math.min(1.0, p_228348_9_ - p_228348_3_);
                double d2 = Math.min(1.0, p_228348_11_ - p_228348_5_);
                double d3 = Math.min(1.0, p_228348_13_ - p_228348_7_);
                int i = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.25)));
                int j = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.25)));
                int k = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.25)));
                for (int l = 0; l < i; ++l) {
                    for (int i1 = 0; i1 < j; ++i1) {
                        for (int j1 = 0; j1 < k; ++j1) {
                            double d4 = ((double)l + 0.5) / (double)i;
                            double d5 = ((double)i1 + 0.5) / (double)j;
                            double d6 = ((double)j1 + 0.5) / (double)k;
                            double d7 = d4 * d1 + p_228348_3_;
                            double d8 = d5 * d2 + p_228348_5_;
                            double d9 = d6 * d3 + p_228348_7_;
                            world.func_217404_b((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, this.blockState).setPos(this.blockPos), true, (double)this.blockPos.func_177958_n() + d7, (double)this.blockPos.func_177984_a().func_177956_o() + d8, (double)this.blockPos.func_177952_p() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5);
                        }
                    }
                }
            }));
        });
        context.get().setPacketHandled(true);
    }
}

