/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.packet;

import chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class HeldBlockPacket {
    private final int entityId;
    private final int blockId;
    private final byte blockIndex;

    public HeldBlockPacket(MutantEndermanEntity enderman, int bId, int index) {
        this.entityId = enderman.func_145782_y();
        this.blockId = bId;
        this.blockIndex = (byte)index;
    }

    void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.writeInt(this.blockId);
        buffer.writeByte((int)this.blockIndex);
    }

    HeldBlockPacket(PacketBuffer buffer) {
        this.entityId = buffer.readInt();
        this.blockId = buffer.readInt();
        this.blockIndex = buffer.readByte();
    }

    void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Optional optionalWorld = (Optional)LogicalSidedProvider.CLIENTWORLD.get(((NetworkEvent.Context)context.get()).getDirection().getReceptionSide());
            optionalWorld.filter(ClientWorld.class::isInstance).ifPresent(world -> {
                MutantEndermanEntity enderman = (MutantEndermanEntity)world.func_73045_a(this.entityId);
                if (enderman != null && this.blockIndex > 0 && this.blockId != -1) {
                    enderman.heldBlock[this.blockIndex] = this.blockId;
                    enderman.heldBlockTick[this.blockIndex] = 0;
                }
            });
        });
        context.get().setPacketHandled(true);
    }
}

