/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.util;

import chumbanotz.mutantbeasts.packet.MBPacketHandler;
import chumbanotz.mutantbeasts.packet.SpawnParticlePacket;
import chumbanotz.mutantbeasts.particles.MBParticleTypes;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityMetadataPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.PacketDistributor;

public class EntityUtil {
    private static final Field STUN_TICK = ObfuscationReflectionHelper.findField(RavagerEntity.class, (String)"field_213692_bA");
    private static final Method GET_SKULL_DROP = ObfuscationReflectionHelper.findMethod(ZombieEntity.class, (String)"func_190732_dj", (Class[])new Class[0]);

    public static float getHeadAngle(LivingEntity livingEntity, double x, double z) {
        return MathHelper.func_203301_d((float)((float)(Math.atan2(z, x) * 180.0 / Math.PI) + 90.0f), (float)livingEntity.field_70759_as);
    }

    public static void spawnLingeringCloud(LivingEntity livingEntity) {
        Collection collection = livingEntity.func_70651_bq();
        if (!collection.isEmpty()) {
            AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(livingEntity.field_70170_p, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_());
            areaeffectcloudentity.func_184483_a(2.5f);
            areaeffectcloudentity.func_184495_b(-0.5f);
            areaeffectcloudentity.func_184485_d(10);
            areaeffectcloudentity.func_184486_b(areaeffectcloudentity.func_184489_o() / 2);
            areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
            for (EffectInstance effectinstance : collection) {
                areaeffectcloudentity.func_184496_a(new EffectInstance(effectinstance));
            }
            livingEntity.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
        }
    }

    public static void stunRavager(LivingEntity livingEntity) {
        if (livingEntity instanceof RavagerEntity) {
            try {
                if (STUN_TICK.getInt(livingEntity) == 0) {
                    STUN_TICK.setInt(livingEntity, 40);
                    livingEntity.func_184185_a(SoundEvents.field_219649_fi, 1.0f, 1.0f);
                    livingEntity.field_70170_p.func_72960_a((Entity)livingEntity, (byte)39);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException("Failed to access ravager stun tick", e);
            }
        }
    }

    public static void sendMetadataPacket(Entity entity) {
        if (entity.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)entity.field_70170_p).func_72863_F().func_217218_b(entity, (IPacket)new SEntityMetadataPacket(entity.func_145782_y(), entity.func_184212_Q(), false));
        }
    }

    public static void sendPlayerVelocityPacket(Entity entity) {
        if (entity instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket(entity));
        }
    }

    public static boolean isFeline(LivingEntity livingEntity) {
        return livingEntity instanceof OcelotEntity || livingEntity instanceof CatEntity;
    }

    public static boolean shouldAttackEntity(TameableEntity tameableEntity, LivingEntity target, LivingEntity owner, boolean canTargetCreepers) {
        if (owner instanceof PlayerEntity) {
            if (target instanceof CreeperEntity) {
                return canTargetCreepers;
            }
            if (target instanceof TameableEntity) {
                UUID targetOwnerUUID = ((TameableEntity)target).func_184753_b();
                UUID attackerOwnerUUID = tameableEntity.func_184753_b();
                return targetOwnerUUID == null || attackerOwnerUUID == null || !targetOwnerUUID.equals(attackerOwnerUUID);
            }
            if (target instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof GolemEntity && !(target instanceof IMob)) {
                return false;
            }
            return !(target instanceof AbstractHorseEntity) || !((AbstractHorseEntity)target).func_110248_bS();
        }
        return true;
    }

    public static <T extends MobEntity> T convertMobWithNBT(LivingEntity mobToConvert, EntityType<T> newEntityType, boolean dropInventory) {
        MobEntity newMob = (MobEntity)newEntityType.func_200721_a(mobToConvert.field_70170_p);
        CompoundNBT copiedNBT = mobToConvert.func_189511_e(new CompoundNBT());
        copiedNBT.func_186854_a("UUID", newMob.func_110124_au());
        copiedNBT.func_218657_a("Attributes", (INBT)SharedMonsterAttributes.func_111257_a((AbstractAttributeMap)newMob.func_110140_aT()));
        copiedNBT.func_74776_a("Health", newMob.func_110143_aJ());
        if (mobToConvert.func_96124_cp() != null) {
            copiedNBT.func_74778_a("Team", mobToConvert.func_96124_cp().func_96661_b());
        }
        if (copiedNBT.func_150297_b("ActiveEffects", 9)) {
            ListNBT activeEffects = copiedNBT.func_150295_c("ActiveEffects", 10);
            for (int i = 0; i < activeEffects.size(); ++i) {
                CompoundNBT compoundnbt = activeEffects.func_150305_b(i);
                EffectInstance effectInstance = EffectInstance.func_82722_b((CompoundNBT)compoundnbt);
                if (effectInstance == null || newMob.func_70687_e(effectInstance)) continue;
                activeEffects.remove(i);
                --i;
            }
        }
        if (dropInventory && mobToConvert.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            BlockState blockstate;
            ItemStack itemStack;
            copiedNBT.func_74757_a("CanPickUpLoot", false);
            if (copiedNBT.func_150297_b("ArmorItems", 9)) {
                ListNBT armorItems = copiedNBT.func_150295_c("ArmorItems", 10);
                ListNBT armorDropChances = copiedNBT.func_150295_c("ArmorDropChances", 5);
                for (int i = 0; i < armorItems.size(); ++i) {
                    itemStack = ItemStack.func_199557_a((CompoundNBT)armorItems.func_150305_b(i));
                    if (itemStack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemStack) || !(armorDropChances.func_150308_e(i) > 1.0f)) continue;
                    mobToConvert.func_199701_a_(itemStack);
                }
                armorItems.clear();
                armorDropChances.clear();
            }
            if (copiedNBT.func_150297_b("HandItems", 9)) {
                ListNBT handItems = copiedNBT.func_150295_c("HandItems", 10);
                ListNBT handDropChances = copiedNBT.func_150295_c("HandDropChances", 5);
                for (int i = 0; i < handItems.size(); ++i) {
                    itemStack = ItemStack.func_199557_a((CompoundNBT)handItems.func_150305_b(i));
                    if (itemStack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemStack) || !(handDropChances.func_150308_e(i) > 1.0f)) continue;
                    mobToConvert.func_199701_a_(itemStack);
                }
                handItems.clear();
                handDropChances.clear();
            }
            if (mobToConvert.func_200600_R() == EntityType.field_200803_q && copiedNBT.func_150297_b("carriedBlockState", 10) && (blockstate = NBTUtil.func_190008_d((CompoundNBT)copiedNBT.func_74775_l("carriedBlockState"))).func_185904_a() != Material.field_151579_a) {
                mobToConvert.func_199703_a((IItemProvider)blockstate.func_177230_c());
            }
        }
        newMob.func_70020_e(copiedNBT);
        mobToConvert.field_70170_p.func_217376_c((Entity)newMob);
        mobToConvert.func_70106_y();
        return (T)newMob;
    }

    public static void spawnParticlesAtEntity(LivingEntity livingEntity, IParticleData particleData, int amount) {
        if (livingEntity.field_70170_p.field_72995_K) {
            for (int i = 0; i < amount; ++i) {
                double posX = livingEntity.func_226277_ct_() + (double)(livingEntity.field_70170_p.field_73012_v.nextFloat() * livingEntity.func_213311_cf() * 2.0f) - (double)livingEntity.func_213311_cf();
                double posY = livingEntity.func_226278_cu_() + 0.5 + (double)(livingEntity.field_70170_p.field_73012_v.nextFloat() * livingEntity.func_213302_cg());
                double posZ = livingEntity.func_226281_cx_() + (double)(livingEntity.field_70170_p.field_73012_v.nextFloat() * livingEntity.func_213311_cf() * 2.0f) - (double)livingEntity.func_213311_cf();
                double x = livingEntity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                double y = livingEntity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                double z = livingEntity.field_70170_p.field_73012_v.nextGaussian() * 0.02;
                livingEntity.field_70170_p.func_195594_a(particleData, posX, posY, posZ, x, y, z);
            }
        }
    }

    public static void spawnEndersoulParticles(Entity entity, int amount, float speed) {
        for (int i = 0; i < amount; ++i) {
            float f = (entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * speed;
            float f1 = (entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * speed;
            float f2 = (entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * speed;
            double tempX = entity.func_226277_ct_() + (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * entity.func_213311_cf());
            double tempY = entity.func_226278_cu_() + (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * entity.func_213302_cg()) + 0.5;
            double tempZ = entity.func_226281_cx_() + (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) * entity.func_213311_cf());
            entity.field_70170_p.func_195594_a((IParticleData)MBParticleTypes.ENDERSOUL, tempX, tempY, tempZ, (double)f, (double)f1, (double)f2);
        }
    }

    public static void sendParticlePacket(Entity entity, IParticleData particleData, int amount) {
        Vec3d vec3d = entity.func_213303_ch();
        MBPacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, 1024.0, entity.field_71093_bK)), (Object)new SpawnParticlePacket(particleData, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, entity.func_213311_cf(), entity.func_213302_cg(), entity.func_213311_cf(), amount));
    }

    public static Vec3d getDirVector(float rotation, float scale) {
        float rad = rotation * ((float)Math.PI / 180);
        return new Vec3d((double)(-MathHelper.func_76126_a((float)rad) * scale), 0.0, (double)(MathHelper.func_76134_b((float)rad) * scale));
    }

    public static boolean teleportTo(MobEntity mob, double x, double y, double z) {
        double oldX = mob.func_226277_ct_();
        double oldY = mob.func_226278_cu_();
        double oldZ = mob.func_226281_cx_();
        double newY = y;
        BlockPos pos = new BlockPos(x, y, z);
        boolean success = false;
        if (mob.field_70170_p.func_195588_v(pos)) {
            boolean temp = false;
            while (!temp && pos.func_177956_o() > 0) {
                BlockPos posDown = pos.func_177977_b();
                if (mob.field_70170_p.func_180495_p(posDown).func_185904_a().func_76230_c()) {
                    temp = true;
                    continue;
                }
                newY -= 1.0;
                pos = posDown;
            }
            if (temp) {
                mob.func_70107_b(x, newY, z);
                if (mob.field_70170_p.func_226669_j_((Entity)mob) && !mob.field_70170_p.func_72953_d(mob.func_174813_aQ())) {
                    success = true;
                }
            }
        }
        if (!success) {
            mob.func_70107_b(oldX, oldY, oldZ);
            return false;
        }
        mob.func_70661_as().func_75499_g();
        return true;
    }

    public static void divertAttackers(MobEntity targetedMob, LivingEntity newTarget) {
        for (MobEntity attacker : targetedMob.field_70170_p.func_217357_a(MobEntity.class, targetedMob.func_174813_aQ().func_72314_b(16.0, 10.0, 16.0))) {
            if (attacker == targetedMob || attacker.func_70638_az() != targetedMob) continue;
            attacker.func_70624_b(newTarget);
        }
    }

    public static ItemStack getSkullDrop(LivingEntity livingEntity) {
        if (livingEntity instanceof ZombieEntity) {
            try {
                return (ItemStack)GET_SKULL_DROP.invoke((Object)livingEntity, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException("Failed to access skull drop from zombie", e);
            }
        }
        if (livingEntity.func_200600_R() == EntityType.field_200797_k) {
            return new ItemStack((IItemProvider)Items.field_196185_dy);
        }
        if (livingEntity.func_200600_R() == EntityType.field_200741_ag) {
            return new ItemStack((IItemProvider)Items.field_196182_dv);
        }
        if (livingEntity.func_200600_R() == EntityType.field_200722_aA) {
            return new ItemStack((IItemProvider)Items.field_196183_dw);
        }
        return ItemStack.field_190927_a;
    }
}

