/*
 * Decompiled with CFR 0.152.
 */
package chumbanotz.mutantbeasts.util;

import chumbanotz.mutantbeasts.packet.FluidParticlePacket;
import chumbanotz.mutantbeasts.packet.MBPacketHandler;
import chumbanotz.mutantbeasts.util.ZombieResurrection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BellBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class SeismicWave
extends BlockPos {
    private final boolean affectsTerrain;
    private boolean first;

    public SeismicWave(int x, int y, int z, boolean affectsTerrain) {
        super(x, y, z);
        this.affectsTerrain = affectsTerrain;
    }

    public boolean isFirst() {
        return this.first;
    }

    public static void createWaves(World world, List<SeismicWave> list, int x1, int z1, int x2, int z2, int y) {
        int deltaX = x2 - x1;
        int deltaZ = z2 - z1;
        int xStep = deltaX < 0 ? -1 : 1;
        int zStep = deltaZ < 0 ? -1 : 1;
        deltaX = Math.abs(deltaX);
        deltaZ = Math.abs(deltaZ);
        int x = x1;
        int z = z1;
        int deltaX2 = deltaX * 2;
        int deltaZ2 = deltaZ * 2;
        SeismicWave wave = SeismicWave.addWave(world, list, x, y, z, true);
        if (wave != null) {
            wave.first = true;
        }
        if (deltaX2 >= deltaZ2) {
            int error = deltaX;
            for (int i = 0; i < deltaX; ++i) {
                x += xStep;
                if ((error += deltaZ2) > deltaX2) {
                    z += zStep;
                    error -= deltaX2;
                }
                SeismicWave.addWave(world, list, x, y, z, false);
            }
        } else {
            int error = deltaZ;
            for (int i = 0; i < deltaZ; ++i) {
                z += zStep;
                if ((error += deltaX2) > deltaZ2) {
                    x += xStep;
                    error -= deltaZ2;
                }
                SeismicWave.addWave(world, list, x, y, z, false);
            }
        }
    }

    @Nullable
    public static SeismicWave addWave(World world, List<SeismicWave> list, int x, int y, int z, boolean first) {
        y = ZombieResurrection.getSuitableGround(world, x, y, z, 3, false);
        SeismicWave wave = null;
        if (y != -1 || first) {
            wave = new SeismicWave(x, y, z, y != -1);
            list.add(wave);
        }
        if (world.field_73012_v.nextInt(2) == 0) {
            list.add(new SeismicWave(x, y + 1, z, false));
        }
        return wave;
    }

    public void affectBlocks(World world, LivingEntity livingEntity) {
        PlayerEntity playerEntity;
        if (!this.affectsTerrain) {
            return;
        }
        BlockPos posAbove = this.func_177984_a();
        BlockState blockstate = world.func_180495_p((BlockPos)this);
        Block block = blockstate.func_177230_c();
        PlayerEntity playerEntity2 = playerEntity = livingEntity instanceof PlayerEntity ? (PlayerEntity)livingEntity : null;
        if (playerEntity != null && playerEntity.func_175142_cm() || world.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
            if (block == Blocks.field_196658_i || block == Blocks.field_185774_da || block == Blocks.field_150458_ak || block == Blocks.field_196661_l || block == Blocks.field_150391_bh) {
                world.func_180501_a((BlockPos)this, Blocks.field_150346_d.func_176223_P(), 2);
            }
            if (block instanceof DoorBlock) {
                if (blockstate.func_185904_a() == Material.field_151575_d) {
                    world.func_217379_c(1021, posAbove, 0);
                } else if (blockstate.func_185904_a() == Material.field_151573_f) {
                    world.func_217379_c(1020, posAbove, 0);
                }
            }
            if (block instanceof TNTBlock) {
                block.catchFire(blockstate, world, (BlockPos)this, null, (LivingEntity)playerEntity);
                world.func_217377_a((BlockPos)this, false);
            }
        }
        if (block instanceof BellBlock) {
            ((BellBlock)block).func_226884_a_(world, blockstate, new BlockRayTraceResult(new Vec3d((Vec3i)this), livingEntity.func_174811_aO(), (BlockPos)this, false), playerEntity, true);
        }
        if (block == Blocks.field_150450_ax) {
            block.func_176199_a(world, (BlockPos)this, (Entity)livingEntity);
        }
        if (blockstate.func_204520_s().func_206888_e()) {
            world.func_217379_c(2001, posAbove, Block.func_196246_j((BlockState)blockstate));
        } else {
            MBPacketHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)this.func_177958_n() + 0.5, (double)this.func_177956_o(), (double)this.func_177952_p() + 0.5, 1024.0, livingEntity.field_71093_bK)), (Object)new FluidParticlePacket(blockstate, this));
        }
    }
}

