/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import net.optifine.expr.IExpressionFloat;

public enum RenderEntityParameterFloat implements IExpressionFloat
{
    LIMB_SWING("limb_swing"),
    LIMB_SWING_SPEED("limb_speed"),
    AGE("age"),
    HEAD_YAW("head_yaw"),
    HEAD_PITCH("head_pitch"),
    HEALTH("health"),
    HURT_TIME("hurt_time"),
    IDLE_TIME("idle_time"),
    MAX_HEALTH("max_health"),
    MOVE_FORWARD("move_forward"),
    MOVE_STRAFING("move_strafing"),
    PARTIAL_TICKS("partial_ticks"),
    POS_X("pos_x"),
    POS_Y("pos_y"),
    POS_Z("pos_z"),
    REVENGE_TIME("revenge_time"),
    SWING_PROGRESS("swing_progress");

    private String name;
    private dvf renderManager;
    private static final RenderEntityParameterFloat[] VALUES;

    private RenderEntityParameterFloat(String name) {
        this.name = name;
        this.renderManager = dbn.x().V();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public float eval() {
        dvg render = this.renderManager.renderRender;
        if (render == null) {
            return 0.0f;
        }
        if (render instanceof dwc) {
            dwc rlb = (dwc)render;
            switch (this) {
                case LIMB_SWING: {
                    return rlb.renderLimbSwing;
                }
                case LIMB_SWING_SPEED: {
                    return rlb.renderLimbSwingAmount;
                }
                case AGE: {
                    return rlb.renderAgeInTicks;
                }
                case HEAD_YAW: {
                    return rlb.renderHeadYaw;
                }
                case HEAD_PITCH: {
                    return rlb.renderHeadPitch;
                }
            }
            akz entity = rlb.renderEntity;
            if (entity == null) {
                return 0.0f;
            }
            switch (this) {
                case HEALTH: {
                    return entity.cS();
                }
                case HURT_TIME: {
                    return entity.av;
                }
                case IDLE_TIME: {
                    return entity.cL();
                }
                case MAX_HEALTH: {
                    return entity.dd();
                }
                case MOVE_FORWARD: {
                    return entity.bb;
                }
                case MOVE_STRAFING: {
                    return entity.aZ;
                }
                case POS_X: {
                    return (float)entity.ct();
                }
                case POS_Y: {
                    return (float)entity.cu();
                }
                case POS_Z: {
                    return (float)entity.cx();
                }
                case REVENGE_TIME: {
                    return entity.cI();
                }
                case SWING_PROGRESS: {
                    return entity.p(rlb.renderPartialTicks);
                }
            }
        }
        return 0.0f;
    }

    public static RenderEntityParameterFloat parse(String str) {
        if (str == null) {
            return null;
        }
        for (int i2 = 0; i2 < VALUES.length; ++i2) {
            RenderEntityParameterFloat type = VALUES[i2];
            if (!type.getName().equals(str)) continue;
            return type;
        }
        return null;
    }

    static {
        VALUES = RenderEntityParameterFloat.values();
    }
}

