/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import com.mojang.blaze3d.platform.GLX;
import java.nio.IntBuffer;
import java.util.List;
import net.optifine.reflect.Reflector;
import net.optifine.render.GlBlendState;
import net.optifine.render.GlCullState;
import net.optifine.render.ICamera;
import net.optifine.render.RenderTypes;
import net.optifine.shaders.ClippingHelperDummy;
import net.optifine.shaders.Shaders;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class ShadersRender {
    private static final sm END_PORTAL_TEXTURE = new sm("textures/entity/end_portal.png");

    public static void setFrustrumPosition(ICamera frustum, double x, double y, double z) {
        frustum.setCameraPosition(x, y, z);
    }

    public static void beginTerrainSolid() {
        if (Shaders.isRenderingWorld) {
            Shaders.fogEnabled = true;
            Shaders.useProgram(Shaders.ProgramTerrain);
        }
    }

    public static void beginTerrainCutoutMipped() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTerrain);
        }
    }

    public static void beginTerrainCutout() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTerrain);
        }
    }

    public static void endTerrain() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTexturedLit);
        }
    }

    public static void beginTranslucent() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramWater);
        }
    }

    public static void endTranslucent() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramTexturedLit);
        }
    }

    public static void renderHand0(dqn er, cyl matrixStackIn, dbb activeRenderInfo, float partialTicks) {
        if (!Shaders.isShadowPass) {
            boolean blockTranslucentMain = Shaders.isItemToRenderMainTranslucent();
            boolean blockTranslucentOff = Shaders.isItemToRenderOffTranslucent();
            if (!blockTranslucentMain || !blockTranslucentOff) {
                Shaders.readCenterDepth();
                Shaders.beginHand(matrixStackIn, false);
                GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Shaders.setSkipRenderHands(blockTranslucentMain, blockTranslucentOff);
                er.renderHand(matrixStackIn, activeRenderInfo, partialTicks, true, false, false);
                Shaders.endHand(matrixStackIn);
                Shaders.setHandsRendered(!blockTranslucentMain, !blockTranslucentOff);
                Shaders.setSkipRenderHands(false, false);
            }
        }
    }

    public static void renderHand1(dqn er, cyl matrixStackIn, dbb activeRenderInfo, float partialTicks) {
        if (!Shaders.isShadowPass && !Shaders.isBothHandsRendered()) {
            Shaders.readCenterDepth();
            cxk.m();
            Shaders.beginHand(matrixStackIn, true);
            GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Shaders.setSkipRenderHands(Shaders.isHandRenderedMain(), Shaders.isHandRenderedOff());
            er.renderHand(matrixStackIn, activeRenderInfo, partialTicks, true, false, true);
            Shaders.endHand(matrixStackIn);
            Shaders.setHandsRendered(true, true);
            Shaders.setSkipRenderHands(false, false);
        }
    }

    public static void renderItemFP(dqp itemRenderer, float partialTicks, cyl matrixStackIn, dqt.a bufferIn, dqb playerEntityIn, int combinedLightIn, boolean renderTranslucent) {
        cxk.a((boolean)true);
        if (renderTranslucent) {
            cxk.b((int)519);
            matrixStackIn.a();
            IntBuffer drawBuffers = Shaders.activeDrawBuffers;
            Shaders.setDrawBuffers(Shaders.drawBuffersNone);
            Shaders.renderItemKeepDepthMask = true;
            itemRenderer.a(partialTicks, matrixStackIn, bufferIn, playerEntityIn, combinedLightIn);
            Shaders.renderItemKeepDepthMask = false;
            Shaders.setDrawBuffers(drawBuffers);
            matrixStackIn.b();
        }
        cxk.b((int)515);
        GL30.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        itemRenderer.a(partialTicks, matrixStackIn, bufferIn, playerEntityIn, combinedLightIn);
    }

    public static void renderFPOverlay(dqn er, cyl matrixStackIn, dbb activeRenderInfo, float partialTicks) {
        if (!Shaders.isShadowPass) {
            Shaders.beginFPOverlay();
            er.renderHand(matrixStackIn, activeRenderInfo, partialTicks, false, true, false);
            Shaders.endFPOverlay();
        }
    }

    public static void beginBlockDamage() {
        if (Shaders.isRenderingWorld) {
            Shaders.useProgram(Shaders.ProgramDamagedBlock);
            if (Shaders.ProgramDamagedBlock.getId() == Shaders.ProgramTerrain.getId()) {
                Shaders.setDrawBuffers(Shaders.drawBuffersColorAtt0);
                cxk.a((boolean)false);
            }
        }
    }

    public static void endBlockDamage() {
        if (Shaders.isRenderingWorld) {
            cxk.a((boolean)true);
            Shaders.useProgram(Shaders.ProgramTexturedLit);
        }
    }

    public static void renderShadowMap(dqn entityRenderer, dbb activeRenderInfo, int pass, float partialTicks, long finishTimeNano) {
        if (Shaders.usedShadowDepthBuffers > 0 && --Shaders.shadowPassCounter <= 0) {
            dbn mc = dbn.x();
            mc.ap().b("shadow pass");
            dqr renderGlobal = mc.d;
            Shaders.isShadowPass = true;
            Shaders.shadowPassCounter = Shaders.shadowPassInterval;
            Shaders.checkGLError("pre shadow");
            GL30.glMatrixMode((int)5889);
            GL11.glPushMatrix();
            GL30.glMatrixMode((int)5888);
            GL11.glPushMatrix();
            mc.ap().b("shadow clear");
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)Shaders.sfb);
            Shaders.checkGLError("shadow bind sfb");
            mc.ap().b("shadow camera");
            ShadersRender.updateActiveRenderInfo(activeRenderInfo, mc, partialTicks);
            cyl matrixStack = new cyl();
            Shaders.setCameraShadow(matrixStack, activeRenderInfo, partialTicks);
            Shaders.checkGLError("shadow camera");
            Shaders.useProgram(Shaders.ProgramShadow);
            GL30.glDrawBuffers((IntBuffer)Shaders.sfbDrawBuffers);
            Shaders.checkGLError("shadow drawbuffers");
            GL30.glReadBuffer((int)0);
            Shaders.checkGLError("shadow readbuffer");
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)Shaders.sfbDepthTextures.get(0), (int)0);
            if (Shaders.usedShadowColorBuffers != 0) {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)Shaders.sfbColorTextures.get(0), (int)0);
            }
            Shaders.checkFramebufferStatus("shadow fb");
            GL30.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL30.glClear((int)(Shaders.usedShadowColorBuffers != 0 ? 16640 : 256));
            Shaders.checkGLError("shadow clear");
            mc.ap().b("shadow frustum");
            ClippingHelperDummy frustum = new ClippingHelperDummy();
            mc.ap().b("shadow culling");
            cvl cameraPos = activeRenderInfo.b();
            frustum.a(cameraPos.b, cameraPos.c, cameraPos.d);
            cxk.u((int)7425);
            cxk.k();
            cxk.b((int)515);
            cxk.a((boolean)true);
            cxk.a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            cxk.lockCull((GlCullState)new GlCullState(false));
            cxk.lockBlend((GlBlendState)new GlBlendState(false));
            mc.ap().b("shadow prepareterrain");
            mc.H().a(eai.d);
            mc.ap().b("shadow setupterrain");
            int frameCount = mc.d.getNextFrameCount();
            renderGlobal.a(activeRenderInfo, (dtm)frustum, false, frameCount, mc.r.t());
            mc.ap().b("shadow updatechunks");
            mc.ap().b("shadow terrain");
            double x = cameraPos.a();
            double y = cameraPos.b();
            double z = cameraPos.c();
            cxk.x((int)5888);
            cxk.P();
            cxk.d();
            renderGlobal.a(RenderTypes.SOLID, matrixStack, x, y, z);
            Shaders.checkGLError("shadow terrain solid");
            cxk.e();
            renderGlobal.a(RenderTypes.CUTOUT_MIPPED, matrixStack, x, y, z);
            Shaders.checkGLError("shadow terrain cutoutmipped");
            mc.H().b(eai.d).a(false, false);
            renderGlobal.a(RenderTypes.CUTOUT, matrixStack, x, y, z);
            Shaders.checkGLError("shadow terrain cutout");
            mc.H().b(eai.d).restoreLastBlurMipmap();
            cxk.u((int)7424);
            cxk.a((int)516, (float)0.1f);
            cxk.x((int)5888);
            cxk.Q();
            cxk.P();
            mc.ap().b("shadow entities");
            dqr wr = mc.d;
            dvf renderManager = mc.V();
            dqt.a irendertypebuffer = wr.getRenderTypeTextures().b();
            boolean playerShadowPass = Shaders.isShadowPass && !mc.r.t();
            for (dqr.a info : wr.getRenderInfosEntities()) {
                dth.c renderChunk = info.b;
                cal chunk = renderChunk.getChunk();
                abe cimm = chunk.z()[renderChunk.e().p() / 16];
                for (akq entity : cimm) {
                    if (!renderManager.a(entity, (dtm)frustum, x, y, z) && !entity.y((akq)mc.r) || entity == activeRenderInfo.g() && !playerShadowPass && !activeRenderInfo.i() && (!(activeRenderInfo.g() instanceof akz) || !((akz)activeRenderInfo.g()).dQ()) || entity instanceof dqb && activeRenderInfo.g() != entity) continue;
                    wr.renderedEntity = entity;
                    Shaders.nextEntity(entity);
                    wr.a(entity, x, y, z, partialTicks, matrixStack, (dqt)irendertypebuffer);
                    wr.renderedEntity = null;
                }
            }
            wr.a(matrixStack);
            irendertypebuffer.a(drb.a((sm)eai.d));
            irendertypebuffer.a(drb.b((sm)eai.d));
            irendertypebuffer.a(drb.c((sm)eai.d));
            irendertypebuffer.a(drb.f((sm)eai.d));
            Shaders.endEntities();
            Shaders.beginBlockEntities();
            dta.updateTextRenderDistance();
            boolean forgeRenderBoundingBox = Reflector.IForgeTileEntity_getRenderBoundingBox.exists();
            ClippingHelperDummy camera = frustum;
            for (dqr.a worldrenderer$localrenderinformationcontainer : wr.getRenderInfosTileEntities()) {
                List list = worldrenderer$localrenderinformationcontainer.b.c().b();
                if (list.isEmpty()) continue;
                for (bwl tileentity1 : list) {
                    cvf aabb;
                    if (forgeRenderBoundingBox && (aabb = (cvf)Reflector.call(tileentity1, Reflector.IForgeTileEntity_getRenderBoundingBox, new Object[0])) != null && !camera.a(aabb)) continue;
                    Shaders.nextBlockEntity(tileentity1);
                    fk blockpos3 = tileentity1.o();
                    matrixStack.a();
                    matrixStack.a((double)blockpos3.o() - x, (double)blockpos3.p() - y, (double)blockpos3.q() - z);
                    dsq.a.a(tileentity1, partialTicks, matrixStack, (dqt)irendertypebuffer);
                    matrixStack.b();
                }
            }
            wr.a(matrixStack);
            irendertypebuffer.a(drb.c());
            irendertypebuffer.a(dre.g());
            irendertypebuffer.a(dre.h());
            irendertypebuffer.a(dre.c());
            irendertypebuffer.a(dre.d());
            irendertypebuffer.a(dre.e());
            irendertypebuffer.a(dre.f());
            irendertypebuffer.a();
            Shaders.endBlockEntities();
            Shaders.checkGLError("shadow entities");
            cxk.x((int)5888);
            cxk.Q();
            cxk.a((boolean)true);
            cxk.l();
            cxk.unlockCull();
            cxk.B();
            cxk.a((int)770, (int)771, (int)1, (int)0);
            cxk.a((int)516, (float)0.1f);
            if (Shaders.usedShadowDepthBuffers >= 2) {
                cxk.r((int)33989);
                Shaders.checkGLError("pre copy shadow depth");
                GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)Shaders.shadowMapWidth, (int)Shaders.shadowMapHeight);
                Shaders.checkGLError("copy shadow depth");
                cxk.r((int)33984);
            }
            cxk.l();
            cxk.a((boolean)true);
            mc.H().a(eai.d);
            cxk.u((int)7425);
            Shaders.checkGLError("shadow pre-translucent");
            GL30.glDrawBuffers((IntBuffer)Shaders.sfbDrawBuffers);
            Shaders.checkGLError("shadow drawbuffers pre-translucent");
            Shaders.checkFramebufferStatus("shadow pre-translucent");
            if (Shaders.isRenderShadowTranslucent()) {
                mc.ap().b("shadow translucent");
                renderGlobal.a(RenderTypes.TRANSLUCENT, matrixStack, x, y, z);
                Shaders.checkGLError("shadow translucent");
            }
            cxk.unlockBlend();
            cxk.u((int)7424);
            cxk.a((boolean)true);
            cxk.B();
            cxk.l();
            GL30.glFlush();
            Shaders.checkGLError("shadow flush");
            Shaders.isShadowPass = false;
            mc.ap().b("shadow postprocess");
            if (Shaders.hasGlGenMipmap) {
                if (Shaders.usedShadowDepthBuffers >= 1) {
                    if (Shaders.shadowMipmapEnabled[0]) {
                        cxk.r((int)33988);
                        cxk.t((int)Shaders.sfbDepthTextures.get(0));
                        GL30.glGenerateMipmap((int)3553);
                        GL30.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowFilterNearest[0] ? 9984 : 9987));
                    }
                    if (Shaders.usedShadowDepthBuffers >= 2 && Shaders.shadowMipmapEnabled[1]) {
                        cxk.r((int)33989);
                        cxk.t((int)Shaders.sfbDepthTextures.get(1));
                        GL30.glGenerateMipmap((int)3553);
                        GL30.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowFilterNearest[1] ? 9984 : 9987));
                    }
                    cxk.r((int)33984);
                }
                if (Shaders.usedShadowColorBuffers >= 1) {
                    if (Shaders.shadowColorMipmapEnabled[0]) {
                        cxk.r((int)33997);
                        cxk.t((int)Shaders.sfbColorTextures.get(0));
                        GL30.glGenerateMipmap((int)3553);
                        GL30.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowColorFilterNearest[0] ? 9984 : 9987));
                    }
                    if (Shaders.usedShadowColorBuffers >= 2 && Shaders.shadowColorMipmapEnabled[1]) {
                        cxk.r((int)33998);
                        cxk.t((int)Shaders.sfbColorTextures.get(1));
                        GL30.glGenerateMipmap((int)3553);
                        GL30.glTexParameteri((int)3553, (int)10241, (int)(Shaders.shadowColorFilterNearest[1] ? 9984 : 9987));
                    }
                    cxk.r((int)33984);
                }
            }
            Shaders.checkGLError("shadow postprocess");
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)Shaders.dfb);
            GL11.glViewport((int)0, (int)0, (int)Shaders.renderWidth, (int)Shaders.renderHeight);
            Shaders.activeDrawBuffers = null;
            mc.H().a(eai.d);
            Shaders.useProgram(Shaders.ProgramTerrain);
            GL30.glMatrixMode((int)5888);
            GL11.glPopMatrix();
            GL30.glMatrixMode((int)5889);
            GL11.glPopMatrix();
            GL30.glMatrixMode((int)5888);
            Shaders.checkGLError("shadow end");
        }
    }

    public static void updateActiveRenderInfo(dbb activeRenderInfo, dbn mc, float partialTicks) {
        activeRenderInfo.a((bjg)mc.q, (akq)(mc.T() == null ? mc.r : mc.T()), mc.j.aD > 0, mc.j.aD == 2, partialTicks);
    }

    public static void preRenderChunkLayer(drb blockLayerIn) {
        if (blockLayerIn == RenderTypes.SOLID) {
            ShadersRender.beginTerrainSolid();
        }
        if (blockLayerIn == RenderTypes.CUTOUT_MIPPED) {
            ShadersRender.beginTerrainCutoutMipped();
        }
        if (blockLayerIn == RenderTypes.CUTOUT) {
            ShadersRender.beginTerrainCutout();
        }
        if (blockLayerIn == RenderTypes.TRANSLUCENT) {
            ShadersRender.beginTranslucent();
        }
        if (Shaders.isRenderBackFace(blockLayerIn)) {
            cxk.C();
        }
        if (GLX.useVbo()) {
            GL20.glEnableVertexAttribArray((int)Shaders.midTexCoordAttrib);
            GL20.glEnableVertexAttribArray((int)Shaders.tangentAttrib);
            GL20.glEnableVertexAttribArray((int)Shaders.entityAttrib);
        }
    }

    public static void postRenderChunkLayer(drb blockLayerIn) {
        if (GLX.useVbo()) {
            GL20.glDisableVertexAttribArray((int)Shaders.midTexCoordAttrib);
            GL20.glDisableVertexAttribArray((int)Shaders.tangentAttrib);
            GL20.glDisableVertexAttribArray((int)Shaders.entityAttrib);
        }
        if (Shaders.isRenderBackFace(blockLayerIn)) {
            cxk.B();
        }
    }

    public static void preRender(drb renderType, cyg buffer) {
        if (!Shaders.isRenderingWorld) {
            return;
        }
        if (Shaders.isShadowPass) {
            return;
        }
        if (renderType.isGlint()) {
            ShadersRender.renderEnchantedGlintBegin();
        } else if (renderType.getName().equals("eyes")) {
            Shaders.beginSpiderEyes();
        } else if (renderType.getName().equals("crumbling")) {
            ShadersRender.beginBlockDamage();
        } else if (renderType == drb.Q) {
            Shaders.beginLeash();
        }
    }

    public static void postRender(drb renderType, cyg buffer) {
        if (!Shaders.isRenderingWorld) {
            return;
        }
        if (Shaders.isShadowPass) {
            return;
        }
        if (renderType.isGlint()) {
            ShadersRender.renderEnchantedGlintEnd();
        } else if (renderType.getName().equals("eyes")) {
            Shaders.endSpiderEyes();
        } else if (renderType.getName().equals("crumbling")) {
            ShadersRender.endBlockDamage();
        } else if (renderType == drb.Q) {
            Shaders.endLeash();
        }
    }

    public static void setupArrayPointersVbo() {
        int vertexSizeI = 16;
        GL20.glVertexAttribPointer((int)Shaders.midTexCoordAttrib, (int)2, (int)5126, (boolean)false, (int)64, (long)36L);
        GL20.glVertexAttribPointer((int)Shaders.tangentAttrib, (int)4, (int)5122, (boolean)false, (int)64, (long)44L);
        GL20.glVertexAttribPointer((int)Shaders.entityAttrib, (int)3, (int)5122, (boolean)false, (int)64, (long)52L);
    }

    public static void beaconBeamBegin() {
        Shaders.useProgram(Shaders.ProgramBeaconBeam);
    }

    public static void beaconBeamStartQuad1() {
    }

    public static void beaconBeamStartQuad2() {
    }

    public static void beaconBeamDraw1() {
    }

    public static void beaconBeamDraw2() {
        cxk.l();
    }

    public static void renderEnchantedGlintBegin() {
        Shaders.useProgram(Shaders.ProgramArmorGlint);
    }

    public static void renderEnchantedGlintEnd() {
        if (Shaders.isRenderingWorld) {
            if (Shaders.isRenderingFirstPersonHand() && Shaders.isRenderBothHands()) {
                Shaders.useProgram(Shaders.ProgramHand);
            } else {
                Shaders.useProgram(Shaders.ProgramEntities);
            }
        } else {
            Shaders.useProgram(Shaders.ProgramNone);
        }
    }

    public static boolean renderEndPortal(bxn te, float partialTicks, float offset, cyl matrixStackIn, dqt bufferIn, int combinedLightIn, int combinedOverlayIn) {
        float zn;
        float yn;
        float xn;
        float zv;
        float yv;
        float xv;
        gg vec3i;
        float du;
        if (!Shaders.isShadowPass && Shaders.activeProgram.getId() == 0) {
            return false;
        }
        cxk.g();
        cyl.a matrixEntry = matrixStackIn.c();
        b matrix = matrixEntry.a();
        a matrixNormal = matrixEntry.b();
        cyo bufferbuilder = bufferIn.getBuffer(drb.a((sm)END_PORTAL_TEXTURE));
        float col = 0.5f;
        float r2 = col * 0.15f;
        float g = col * 0.3f;
        float b2 = col * 0.4f;
        float u0 = 0.0f;
        float u1 = 0.2f;
        float v0 = u0;
        float v1 = u1;
        float dv = du = (float)(System.currentTimeMillis() % 100000L) / 100000.0f;
        float dy = offset;
        int lm = combinedLightIn;
        int ov = combinedOverlayIn;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (te.a(fp.d)) {
            vec3i = fp.d.p();
            xv = vec3i.o();
            yv = vec3i.p();
            zv = vec3i.q();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x, y, z + 1.0f).a(r2, g, b2, 1.0f).a(u0 + du, v0 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x + 1.0f, y, z + 1.0f).a(r2, g, b2, 1.0f).a(u0 + du, v1 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x + 1.0f, y + 1.0f, z + 1.0f).a(r2, g, b2, 1.0f).a(u1 + du, v1 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x, y + 1.0f, z + 1.0f).a(r2, g, b2, 1.0f).a(u1 + du, v0 + dv).b(ov).a(lm).a(xn, yn, zn).a();
        }
        if (te.a(fp.c)) {
            vec3i = fp.c.p();
            xv = vec3i.o();
            yv = vec3i.p();
            zv = vec3i.q();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x, y + 1.0f, z).a(r2, g, b2, 1.0f).a(u1 + du, v1 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x + 1.0f, y + 1.0f, z).a(r2, g, b2, 1.0f).a(u1 + du, v0 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x + 1.0f, y, z).a(r2, g, b2, 1.0f).a(u0 + du, v0 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x, y, z).a(r2, g, b2, 1.0f).a(u0 + du, v1 + dv).b(ov).a(lm).a(xn, yn, zn).a();
        }
        if (te.a(fp.f)) {
            vec3i = fp.f.p();
            xv = vec3i.o();
            yv = vec3i.p();
            zv = vec3i.q();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x + 1.0f, y + 1.0f, z).a(r2, g, b2, 1.0f).a(u1 + du, v1 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x + 1.0f, y + 1.0f, z + 1.0f).a(r2, g, b2, 1.0f).a(u1 + du, v0 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x + 1.0f, y, z + 1.0f).a(r2, g, b2, 1.0f).a(u0 + du, v0 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x + 1.0f, y, z).a(r2, g, b2, 1.0f).a(u0 + du, v1 + dv).b(ov).a(lm).a(xn, yn, zn).a();
        }
        if (te.a(fp.e)) {
            vec3i = fp.e.p();
            xv = vec3i.o();
            yv = vec3i.p();
            zv = vec3i.q();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x, y, z).a(r2, g, b2, 1.0f).a(u0 + du, v0 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x, y, z + 1.0f).a(r2, g, b2, 1.0f).a(u0 + du, v1 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x, y + 1.0f, z + 1.0f).a(r2, g, b2, 1.0f).a(u1 + du, v1 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x, y + 1.0f, z).a(r2, g, b2, 1.0f).a(u1 + du, v0 + dv).b(ov).a(lm).a(xn, yn, zn).a();
        }
        if (te.a(fp.a)) {
            vec3i = fp.a.p();
            xv = vec3i.o();
            yv = vec3i.p();
            zv = vec3i.q();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x, y, z).a(r2, g, b2, 1.0f).a(u0 + du, v0 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x + 1.0f, y, z).a(r2, g, b2, 1.0f).a(u0 + du, v1 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x + 1.0f, y, z + 1.0f).a(r2, g, b2, 1.0f).a(u1 + du, v1 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x, y, z + 1.0f).a(r2, g, b2, 1.0f).a(u1 + du, v0 + dv).b(ov).a(lm).a(xn, yn, zn).a();
        }
        if (te.a(fp.b)) {
            vec3i = fp.b.p();
            xv = vec3i.o();
            yv = vec3i.p();
            zv = vec3i.q();
            xn = matrixNormal.getTransformX(xv, yv, zv);
            yn = matrixNormal.getTransformY(xv, yv, zv);
            zn = matrixNormal.getTransformZ(xv, yv, zv);
            bufferbuilder.a(matrix, x, y + dy, z + 1.0f).a(r2, g, b2, 1.0f).a(u0 + du, v0 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x + 1.0f, y + dy, z + 1.0f).a(r2, g, b2, 1.0f).a(u0 + du, v1 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x + 1.0f, y + dy, z).a(r2, g, b2, 1.0f).a(u1 + du, v1 + dv).b(ov).a(lm).a(xn, yn, zn).a();
            bufferbuilder.a(matrix, x, y + dy, z).a(r2, g, b2, 1.0f).a(u1 + du, v0 + dv).b(ov).a(lm).a(xn, yn, zn).a();
        }
        cxk.f();
        return true;
    }
}

