/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.gutters;

import com.mcwroofs.kikoz.objects.gutters.GutterBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class RainGutterCenter
extends GutterBase
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)6.0, (double)0.0, (double)13.0, (double)10.0, (double)11.0, (double)17.0);
    private static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)6.0, (double)0.0, (double)-1.0, (double)10.0, (double)11.0, (double)3.0);
    private static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)-1.0, (double)0.0, (double)6.0, (double)3.0, (double)11.0, (double)10.0);
    private static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)13.0, (double)0.0, (double)6.0, (double)17.0, (double)11.0, (double)10.0);
    private static final BooleanProperty WATER = BooleanProperty.func_177716_a((String)"water");
    private static final VoxelShape BOT_WEST = Block.func_208617_a((double)6.0, (double)6.0, (double)9.0, (double)10.0, (double)11.0, (double)17.0);
    private static final VoxelShape BOT_EAST = Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)11.0, (double)7.0);
    private static final VoxelShape BOT_NORTH = Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)7.0, (double)11.0, (double)10.0);
    private static final VoxelShape BOT_SOUTH = Block.func_208617_a((double)9.0, (double)6.0, (double)6.0, (double)17.0, (double)11.0, (double)10.0);
    private static final VoxelShape C_WEST = Block.func_208617_a((double)0.0, (double)11.0, (double)12.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape C_EAST = Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)4.0);
    private static final VoxelShape C_NORTH = Block.func_208617_a((double)0.0, (double)11.0, (double)0.0, (double)4.0, (double)15.0, (double)16.0);
    private static final VoxelShape C_SOUTH = Block.func_208617_a((double)12.0, (double)11.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0);
    private static final VoxelShape WEST = VoxelShapes.func_216384_a((VoxelShape)SHAPE_WEST, (VoxelShape[])new VoxelShape[]{BOT_WEST, C_WEST});
    private static final VoxelShape EAST = VoxelShapes.func_216384_a((VoxelShape)SHAPE_EAST, (VoxelShape[])new VoxelShape[]{BOT_EAST, C_EAST});
    private static final VoxelShape NORTH = VoxelShapes.func_216384_a((VoxelShape)SHAPE_NORTH, (VoxelShape[])new VoxelShape[]{BOT_NORTH, C_NORTH});
    private static final VoxelShape SOUTH = VoxelShapes.func_216384_a((VoxelShape)SHAPE_SOUTH, (VoxelShape[])new VoxelShape[]{BOT_SOUTH, C_SOUTH});

    public RainGutterCenter() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200948_a(1.25f, 3.5f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)WATER, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case WEST: {
                return WEST;
            }
            case EAST: {
                return EAST;
            }
            case SOUTH: {
                return SOUTH;
            }
        }
        return NORTH;
    }

    @Override
    public VoxelShape getBoundingBox(BlockState state, BlockPos pos) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            default: {
                return SOUTH;
            }
            case NORTH: {
                return NORTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: 
        }
        return WEST;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176746_e())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8));
    }

    @Override
    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{WATER, FACING, WATERLOGGED});
    }

    public boolean func_149653_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATER) == true;
    }

    public void randomTick(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((IProperty)WATER)).booleanValue() && worldIn.field_73012_v.nextInt(2) == 1 && !worldIn.func_175727_C(pos.func_177984_a())) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)WATER, (Comparable)Boolean.valueOf(false)));
        }
    }

    public void func_176224_k(World worldIn, BlockPos pos) {
        BlockState blockstate;
        float f = worldIn.func_226691_t_(pos).func_225486_c(pos);
        if (!(f < 0.15f) && !((Boolean)(blockstate = worldIn.func_180495_p(pos)).func_177229_b((IProperty)WATER)).booleanValue()) {
            worldIn.func_175656_a(pos, (BlockState)blockstate.func_206870_a((IProperty)WATER, (Comparable)Boolean.valueOf(true)));
        }
    }
}

