/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.init;

import com.mrcrayfish.goblintraders.entity.GoblinTraderEntity;
import com.mrcrayfish.goblintraders.entity.VeinGoblinTraderEntity;
import com.mrcrayfish.goblintraders.item.SupplierSpawnEggItem;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="goblintraders", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTER = new DeferredRegister(ForgeRegistries.ENTITIES, "goblintraders");
    public static final RegistryObject<EntityType<GoblinTraderEntity>> GOBLIN_TRADER = ModEntities.build("goblin_trader", GoblinTraderEntity::new, 0.5f, 1.0f);
    public static final RegistryObject<EntityType<VeinGoblinTraderEntity>> VEIN_GOBLIN_TRADER = ModEntities.build("vein_goblin_trader", VeinGoblinTraderEntity::new, 0.5f, 1.0f);

    private static <T extends Entity> RegistryObject<EntityType<T>> build(String id, Function<World, T> function, float width, float height) {
        EntityType.Builder builder = EntityType.Builder.func_220322_a((entityType, world) -> (Entity)function.apply(world), (EntityClassification)EntityClassification.CREATURE).func_220321_a(width, height).setCustomClientFactory((spawnEntity, world) -> (Entity)function.apply((World)world));
        builder.func_220320_c();
        EntityType type = builder.func_206830_a(id);
        return REGISTER.register(id, () -> type);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void register(RegistryEvent.Register<EntityType<?>> event) {
        SupplierSpawnEggItem.updateEggMap();
    }
}

