/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.trades;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mrcrayfish.goblintraders.trades.TradeManager;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.trades.TradeSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;

public class EntityTrades {
    private final Map<TradeRarity, List<VillagerTrades.ITrade>> tradeMap;

    public EntityTrades(Map<TradeRarity, List<VillagerTrades.ITrade>> tradeMap) {
        this.tradeMap = ImmutableMap.copyOf(tradeMap);
    }

    public Map<TradeRarity, List<VillagerTrades.ITrade>> getTradeMap() {
        return this.tradeMap;
    }

    public static class Builder {
        private final Map<TradeRarity, List<VillagerTrades.ITrade>> tradeMap = (Map)Util.func_199748_a(() -> {
            EnumMap map = new EnumMap(TradeRarity.class);
            Arrays.stream(TradeRarity.values()).forEach(rarity -> {
                List cfr_ignored_0 = map.put((TradeRarity)((Object)((Object)rarity)), new ArrayList());
            });
            return map;
        });

        private Builder() {
        }

        public EntityTrades build() {
            return new EntityTrades(this.tradeMap);
        }

        void deserialize(TradeRarity rarity, JsonObject object) {
            List<VillagerTrades.ITrade> trades = this.tradeMap.get((Object)rarity);
            if (JSONUtils.func_151209_a((JsonObject)object, (String)"replace", (boolean)false)) {
                trades.clear();
            }
            JsonArray tradeArray = JSONUtils.func_151214_t((JsonObject)object, (String)"trades");
            for (JsonElement tradeElement : tradeArray) {
                JsonObject tradeObject = tradeElement.getAsJsonObject();
                String rawType = JSONUtils.func_151200_h((JsonObject)tradeObject, (String)"type");
                ResourceLocation typeKey = ResourceLocation.func_208304_a((String)rawType);
                if (typeKey == null) {
                    throw new JsonParseException("");
                }
                TradeSerializer<?> serializer = TradeManager.instance().getTypeSerializer(typeKey);
                if (serializer == null) {
                    throw new JsonParseException(String.format("Invalid trade type: %s", typeKey));
                }
                trades.add((VillagerTrades.ITrade)serializer.deserialize(tradeObject).createVillagerTrade());
            }
        }

        static Builder create() {
            return new Builder();
        }
    }
}

