/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.world.spawner;

import com.mrcrayfish.goblintraders.world.spawner.GoblinData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;

public class GoblinTraderData
extends WorldSavedData {
    private static final String DATA_NAME = "goblintraders_goblin_trader";
    private Map<String, GoblinData> data = new HashMap<String, GoblinData>();

    public GoblinTraderData() {
        super(DATA_NAME);
    }

    public GoblinTraderData(String name) {
        super(name);
    }

    public GoblinData getGoblinData(String key) {
        return this.data.computeIfAbsent(key, s -> new GoblinData(this));
    }

    public void func_76184_a(CompoundNBT compound) {
        if (compound.func_150297_b("GoblinTraderSpawnDelay", 3)) {
            this.getGoblinData("GoblinTrader").setGoblinTraderSpawnDelay(compound.func_74762_e("GoblinTraderSpawnDelay"));
        }
        if (compound.func_150297_b("GoblinTraderSpawnChance", 3)) {
            this.getGoblinData("GoblinTrader").setGoblinTraderSpawnChance(compound.func_74762_e("GoblinTraderSpawnChance"));
        }
        if (compound.func_186855_b("GoblinTraderId")) {
            this.getGoblinData("GoblinTrader").setGoblinTraderId(compound.func_186857_a("GoblinTraderId"));
        }
        if (compound.func_150297_b("Data", 9)) {
            this.data.clear();
            ListNBT list = compound.func_150295_c("Data", 10);
            list.forEach(nbt -> {
                CompoundNBT goblinTag = (CompoundNBT)nbt;
                String key = goblinTag.func_74779_i("Key");
                GoblinData data = new GoblinData(this);
                data.read(goblinTag);
                this.data.put(key, data);
            });
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        this.data.forEach((s, goblinData) -> {
            CompoundNBT goblinTag = new CompoundNBT();
            goblinData.write(goblinTag);
            goblinTag.func_74778_a("Key", s);
            list.add((Object)goblinTag);
        });
        compound.func_218657_a("Data", (INBT)list);
        return compound;
    }

    public static GoblinTraderData get(MinecraftServer server) {
        ServerWorld world = server.func_71218_a(DimensionType.field_223227_a_);
        return (GoblinTraderData)world.func_217481_x().func_215752_a(GoblinTraderData::new, DATA_NAME);
    }
}

