/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.world.spawner;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.init.ModEntities;
import com.mrcrayfish.goblintraders.world.spawner.GoblinData;
import com.mrcrayfish.goblintraders.world.spawner.GoblinTraderData;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;

public class GoblinTraderSpawner {
    private final GoblinData data;
    private final EntityType<? extends AbstractGoblinEntity> entityType;
    private int delayBeforeSpawnLogic;
    private final int traderSpawnDelay;
    private final int traderSpawnChance;
    private int currentTraderSpawnDelay;
    private int currentTraderSpawnChance;
    private int minLevel;
    private int maxLevel;

    public GoblinTraderSpawner(MinecraftServer server, String key, EntityType<? extends AbstractGoblinEntity> entityType, Config.Common.Goblin goblin) {
        this.data = GoblinTraderData.get(server).getGoblinData(key);
        this.entityType = entityType;
        this.delayBeforeSpawnLogic = 600;
        this.currentTraderSpawnDelay = this.data.getGoblinTraderSpawnDelay();
        this.currentTraderSpawnChance = this.data.getGoblinTraderSpawnChance();
        this.traderSpawnDelay = (Integer)goblin.traderSpawnDelay.get();
        this.traderSpawnChance = (Integer)goblin.traderSpawnChance.get();
        this.minLevel = Math.min((Integer)goblin.traderMinSpawnLevel.get(), (Integer)goblin.traderMaxSpawnLevel.get());
        this.maxLevel = Math.max((Integer)goblin.traderMinSpawnLevel.get(), (Integer)goblin.traderMaxSpawnLevel.get());
        if (this.currentTraderSpawnDelay == 0 && this.currentTraderSpawnChance == 0) {
            this.currentTraderSpawnDelay = this.traderSpawnDelay;
            this.currentTraderSpawnChance = this.traderSpawnChance;
            this.data.setGoblinTraderSpawnDelay(this.currentTraderSpawnDelay);
            this.data.setGoblinTraderSpawnChance(this.currentTraderSpawnChance);
        }
    }

    public int tick(World world) {
        if (world.func_82736_K().func_223586_b(GameRules.field_230128_E_) && --this.delayBeforeSpawnLogic <= 0) {
            int delay;
            this.delayBeforeSpawnLogic = delay = this.traderSpawnDelay / 20;
            this.currentTraderSpawnDelay -= delay;
            this.data.setGoblinTraderSpawnDelay(this.currentTraderSpawnDelay);
            if (this.currentTraderSpawnDelay <= 0) {
                this.currentTraderSpawnDelay = this.traderSpawnDelay;
                if (world.func_82736_K().func_223586_b(GameRules.field_223601_d)) {
                    int spawnChance = this.currentTraderSpawnChance;
                    this.currentTraderSpawnChance = MathHelper.func_76125_a((int)(this.currentTraderSpawnChance + this.traderSpawnChance), (int)this.traderSpawnChance, (int)100);
                    this.data.setGoblinTraderSpawnChance(this.currentTraderSpawnChance);
                    if (world.field_73012_v.nextInt(100) <= spawnChance && this.spawnTrader(world)) {
                        this.currentTraderSpawnChance = this.traderSpawnChance;
                    }
                }
            }
        }
        return 0;
    }

    private boolean spawnTrader(World world) {
        ArrayList players = new ArrayList(world.func_217369_A());
        if (players.isEmpty()) {
            return false;
        }
        PlayerEntity randomPlayer = (PlayerEntity)players.get(world.field_73012_v.nextInt(players.size()));
        if (randomPlayer == null) {
            return true;
        }
        BlockPos blockpos = randomPlayer.func_180425_c();
        BlockPos safestPos = this.getSafePositionAroundPlayer(randomPlayer.field_70170_p, blockpos, 10);
        if (safestPos != null && this.isEmptyCollision(randomPlayer.field_70170_p, safestPos)) {
            if (safestPos.func_177956_o() < this.minLevel || safestPos.func_177956_o() >= this.maxLevel) {
                return false;
            }
            AbstractGoblinEntity goblin = (AbstractGoblinEntity)this.entityType.func_220342_a((World)((ServerWorld)randomPlayer.field_70170_p), (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, safestPos, SpawnReason.EVENT, false, false);
            if (goblin != null) {
                this.data.setGoblinTraderId(goblin.func_110124_au());
                goblin.setDespawnDelay(this.traderSpawnDelay);
                goblin.func_213390_a(safestPos, 16);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private BlockPos getSafePositionAroundPlayer(World world, BlockPos pos, int range) {
        if (range == 0) {
            return null;
        }
        BlockPos safestPos = null;
        for (int attempts = 0; attempts < 50; ++attempts) {
            int posZ;
            int posY;
            int posX = pos.func_177958_n() + world.field_73012_v.nextInt(range * 2) - range;
            BlockPos testPos = this.findGround(world, new BlockPos(posX, posY = pos.func_177956_o() + world.field_73012_v.nextInt(range) - range / 2, posZ = pos.func_177952_p() + world.field_73012_v.nextInt(range * 2) - range), range);
            if (testPos == null || !WorldEntitySpawner.func_209382_a((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (IWorldReader)world, (BlockPos)testPos, (EntityType)((EntityType)ModEntities.GOBLIN_TRADER.get()))) continue;
            safestPos = testPos;
            break;
        }
        return safestPos != null ? safestPos : this.getSafePositionAroundPlayer(world, pos, range / 2);
    }

    @Nullable
    private BlockPos findGround(World world, BlockPos pos, int maxDistance) {
        if (world.func_175623_d(pos)) {
            BlockPos downPos = pos;
            while (World.func_175701_a((BlockPos)downPos.func_177977_b()) && world.func_175623_d(downPos.func_177977_b()) && downPos.func_177977_b().func_218141_a((Vec3i)pos, (double)maxDistance)) {
                downPos = downPos.func_177977_b();
            }
            if (!world.func_175623_d(downPos.func_177977_b())) {
                return downPos;
            }
        } else {
            BlockPos upPos = pos;
            while (World.func_175701_a((BlockPos)upPos.func_177984_a()) && !world.func_175623_d(upPos.func_177984_a()) && upPos.func_177984_a().func_218141_a((Vec3i)pos, (double)maxDistance)) {
                upPos = upPos.func_177984_a();
            }
            if (!world.func_175623_d(upPos.func_177977_b())) {
                return upPos;
            }
        }
        return null;
    }

    private boolean isEmptyCollision(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_196952_d((IBlockReader)world, pos).func_197766_b();
    }
}

