/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ReportedException;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import yalter.mousetweaks.Constants;
import yalter.mousetweaks.Logger;
import yalter.mousetweaks.ObfuscatedName;
import yalter.mousetweaks.Obfuscation;
import yalter.mousetweaks.ReflectionCache;

public class Reflection {
    private static Obfuscation obfuscation;
    private static boolean checkObfuscation;
    private static HashMap<Class<?>, Method> HMCCache;
    public static ReflectionCache guiContainerClass;

    static void reflectGuiContainer() {
        Field f;
        Logger.Log("Reflecting GuiContainer...");
        guiContainerClass = new ReflectionCache();
        try {
            f = Reflection.getField(ContainerScreen.class, Reflection.getObfuscatedName(Constants.IGNOREMOUSEUP_NAME));
            guiContainerClass.storeField(Constants.IGNOREMOUSEUP_NAME.forgeName, f);
        }
        catch (NoSuchFieldException e) {
            Logger.Log("Could not retrieve GuiContainer.ignoreMouseUp.");
            guiContainerClass = null;
            return;
        }
        try {
            f = Reflection.getField(ContainerScreen.class, Reflection.getObfuscatedName(Constants.DRAGSPLITTING_NAME));
            guiContainerClass.storeField(Constants.DRAGSPLITTING_NAME.forgeName, f);
        }
        catch (NoSuchFieldException e) {
            Logger.Log("Could not retrieve GuiContainer.dragSplitting.");
            guiContainerClass = null;
            return;
        }
        try {
            f = Reflection.getField(ContainerScreen.class, Reflection.getObfuscatedName(Constants.DRAGSPLITTINGBUTTON_NAME));
            guiContainerClass.storeField(Constants.DRAGSPLITTINGBUTTON_NAME.forgeName, f);
        }
        catch (NoSuchFieldException e) {
            Logger.Log("Could not retrieve GuiContainer.dragSplittingButton.");
            guiContainerClass = null;
            return;
        }
        try {
            Method m = Reflection.getMethod(ContainerScreen.class, Reflection.getObfuscatedName(Constants.GETSELECTEDSLOT_NAME), Double.TYPE, Double.TYPE);
            guiContainerClass.storeMethod(Constants.GETSELECTEDSLOT_NAME.forgeName, m);
        }
        catch (NoSuchMethodException e) {
            Logger.Log("Could not retrieve GuiContainer.getSelectedSlot().");
            guiContainerClass = null;
            return;
        }
        Logger.Log("Success.");
    }

    public static Method getHMCMethod(ContainerScreen object) {
        if (HMCCache.containsKey(object.getClass())) {
            return HMCCache.get(object.getClass());
        }
        try {
            Method method = Reflection.searchMethod(object.getClass(), Reflection.getObfuscatedName(Constants.HANDLEMOUSECLICK_NAME), Slot.class, Integer.TYPE, Integer.TYPE, ClickType.class);
            Logger.DebugLog("Found handleMouseClick() for " + object.getClass().getSimpleName() + ", caching.");
            HMCCache.put(object.getClass(), method);
            return method;
        }
        catch (NoSuchMethodException e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"MouseTweaks could not find handleMouseClick() in a ContainerScreen.");
            throw new ReportedException(crashreport);
        }
    }

    public static Method getHMCMethod(Object object) {
        if (HMCCache.containsKey(object.getClass())) {
            return HMCCache.get(object.getClass());
        }
        try {
            Method method = Reflection.searchMethod(object.getClass(), Reflection.getObfuscatedName(Constants.HANDLEMOUSECLICK_NAME), Slot.class, Integer.TYPE, Integer.TYPE, ClickType.class);
            Logger.DebugLog("Found handleMouseClick() for " + object.getClass().getSimpleName() + ", caching.");
            HMCCache.put(object.getClass(), method);
            return method;
        }
        catch (NoSuchMethodException e) {
            Logger.DebugLog("Could not find handleMouseClick() for " + object.getClass().getSimpleName() + ", using windowClick().");
            return null;
        }
    }

    static boolean doesClassExist(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static Field getField(Class<?> clazz, String name) throws NoSuchFieldException {
        Field field;
        try {
            field = clazz.getField(name);
        }
        catch (NoSuchFieldException e) {
            field = clazz.getDeclaredField(name);
        }
        field.setAccessible(true);
        return field;
    }

    private static Method getMethod(Class<?> clazz, String name, Class<?> ... args) throws NoSuchMethodException {
        Method method;
        try {
            method = clazz.getMethod(name, args);
        }
        catch (NoSuchMethodException e) {
            method = clazz.getDeclaredMethod(name, args);
        }
        method.setAccessible(true);
        return method;
    }

    private static Method searchMethod(Class<?> clazz, String name, Class<?> ... args) throws NoSuchMethodException {
        while (true) {
            try {
                Method method = clazz.getDeclaredMethod(name, args);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException e) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw new NoSuchMethodException();
            }
            break;
        }
    }

    private static String getObfuscatedName(ObfuscatedName obfuscatedName) {
        if (checkObfuscation) {
            Reflection.checkObfuscation();
        }
        return obfuscatedName.get(obfuscation);
    }

    private static void checkObfuscation() {
        checkObfuscation = false;
        try {
            Reflection.getField(ContainerScreen.class, Constants.IGNOREMOUSEUP_NAME.mcpName);
            obfuscation = Obfuscation.MCP;
        }
        catch (NoSuchFieldException e) {
            try {
                Reflection.getField(ContainerScreen.class, Constants.IGNOREMOUSEUP_NAME.forgeName);
                obfuscation = Obfuscation.FORGE;
            }
            catch (NoSuchFieldException ex) {
                obfuscation = Obfuscation.VANILLA;
            }
        }
        Logger.Log("Detected obfuscation: " + (Object)((Object)obfuscation) + ".");
    }

    static {
        checkObfuscation = true;
        HMCCache = new HashMap();
    }
}

