/*
 * Decompiled with CFR 0.152.
 */
package yalter.mousetweaks.forge;

import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import yalter.mousetweaks.Logger;
import yalter.mousetweaks.Main;
import yalter.mousetweaks.MouseButton;

@Mod(value="mousetweaks")
public class MouseTweaksForge {
    public MouseTweaksForge() {
        if (FMLEnvironment.dist != Dist.CLIENT) {
            Logger.Log("Disabled because not running on the client.");
            return;
        }
        Main.initialize();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        Logger.DebugLog("onGuiOpen gui = " + event.getGui());
        Main.onGuiOpen(event.getGui());
    }

    @SubscribeEvent
    public void onGuiMouseClickedPre(GuiScreenEvent.MouseClickedEvent.Pre event) {
        Logger.DebugLog("onGuiMouseClickedPre button = " + event.getButton());
        MouseButton button = MouseTweaksForge.eventButtonToMouseButton(event.getButton());
        if (button != null && Main.onMouseClicked(event.getMouseX(), event.getMouseY(), button)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiMouseReleasedPre(GuiScreenEvent.MouseReleasedEvent.Pre event) {
        Logger.DebugLog("onGuiMouseReleasedPre button = " + event.getButton());
        MouseButton button = MouseTweaksForge.eventButtonToMouseButton(event.getButton());
        if (button != null && Main.onMouseReleased(event.getMouseX(), event.getMouseY(), button)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiMouseScrollPost(GuiScreenEvent.MouseScrollEvent.Post event) {
        Logger.DebugLog("onGuiMouseScrollPost delta = " + event.getScrollDelta());
        if (Main.onMouseScrolled(event.getMouseX(), event.getMouseY(), event.getScrollDelta())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onGuiMouseDragPre(GuiScreenEvent.MouseDragEvent.Pre event) {
        Logger.DebugLog("onGuiMouseDragPre button = " + event.getMouseButton() + ", dx = " + event.getDragX() + ", dy = " + event.getDragY());
        MouseButton button = MouseTweaksForge.eventButtonToMouseButton(event.getMouseButton());
        if (button != null && Main.onMouseDrag(event.getMouseX(), event.getMouseY(), button)) {
            event.setCanceled(true);
        }
    }

    private static MouseButton eventButtonToMouseButton(int eventButton) {
        switch (eventButton) {
            case 0: {
                return MouseButton.LEFT;
            }
            case 1: {
                return MouseButton.RIGHT;
            }
        }
        return null;
    }
}

