/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.client.gui;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class ScrollableListButton
extends ExtendedButton {
    private static final ResourceLocation MISC = new ResourceLocation("teamlapenlib", "textures/gui/misc.png");
    protected final int menuSize;
    protected int itemCount;
    protected int scrolled;
    private boolean scrollerPressed;
    protected final Button[] elements;
    private final Consumer<Integer> pressConsumer;
    private final String[] desc;
    private final boolean alternate;

    public ScrollableListButton(int xPos, int yPos, int width, int shownItems, int maxItemCount, @Nullable String[] strings, String displayString, Consumer<Integer> elementPressAction, boolean alternate) {
        super(xPos, yPos + 1, width, Math.min(shownItems, maxItemCount) * 20, displayString, button -> {});
        this.itemCount = maxItemCount;
        this.menuSize = shownItems;
        this.visible = true;
        this.elements = new Button[this.menuSize];
        this.pressConsumer = elementPressAction;
        this.desc = strings;
        this.alternate = alternate;
        this.fillElements();
    }

    public ScrollableListButton(int xPos, int yPos, int width, int height, int itemCount, String[] strings, String displayString, Consumer<Integer> elementPressAction) {
        this(xPos, yPos, width, height, itemCount, strings, displayString, elementPressAction, false);
    }

    protected void fillElements() {
        for (int i = 0; i < this.elements.length; ++i) {
            int finalI = i;
            this.elements[i] = new ExtendedButton(this.x, this.y + i * 20, this.width - 7, 20, "", button -> this.pressConsumer.accept(finalI + this.scrolled));
        }
    }

    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        if (this.visible) {
            this.hLine(this.x, this.x + this.width, this.y - 1, this.alternate ? -13158601 : -16777216);
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)MISC, (int)(this.x + this.width - 8), (int)(this.y - 1), (int)(this.alternate ? 23 : 0), (int)0, (int)9, (int)(this.height + 2), (int)9, (int)200, (int)2, (int)2, (int)2, (int)2, (float)this.getBlitOffset());
            this.renderScroller();
            this.renderListButtons(mouseX, mouseY, partialTicks);
            if (this.elements.length != 0 && this.elements[this.elements.length - 1].visible) {
                this.hLine(this.x, this.x + this.width, this.y + this.height, this.alternate ? -1 : -16777216);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int buttonId) {
        if (this.visible) {
            this.scrollerPressed = false;
            if (mouseX > (double)this.x && mouseX < (double)(this.x + this.width) && mouseY > (double)this.y && mouseY < (double)(this.y + this.height)) {
                if (this.itemCount - this.menuSize > 0 && mouseX > (double)(this.x + this.width - 8)) {
                    this.scrollerPressed = true;
                }
                for (Button button : this.elements) {
                    if (!button.mouseClicked(mouseX, mouseY, buttonId)) continue;
                    return true;
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, buttonId);
    }

    protected void renderScroller() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(MISC);
        int i = this.itemCount - this.menuSize;
        if (i >= 1) {
            float k = (float)(this.height + 3 - 30) / (float)i;
            int i1 = Math.min(this.height + 3 - 30, (int)((float)this.scrolled * k));
            if (this.scrolled >= i) {
                i1 = this.height + 3 - 30;
            }
            ScrollableListButton.blit((int)(this.x + this.width - 7), (int)(this.y + i1), (int)this.getBlitOffset(), (float)((this.alternate ? 23 : 0) + 10 - 1), (float)0.0f, (int)7, (int)27, (int)256, (int)256);
        }
    }

    private void renderListButtons(int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.elements.length; ++i) {
            boolean bl = this.elements[i].visible = this.itemCount > this.menuSize || i < this.itemCount;
            if (!this.elements[i].visible) continue;
            this.elements[i].render(mouseX, mouseY, partialTicks);
            String desc = this.desc != null ? this.desc[this.scrolled + i] : "Type " + (i + this.scrolled + 1);
            int x = this.x + (this.width - 8) / 2 - Minecraft.func_71410_x().field_71466_p.func_78256_a(desc) / 2;
            Minecraft.func_71410_x().field_71466_p.func_175063_a(desc, (float)x, (float)(this.y + 6 + i * 20), this.elements[i].getFGColor());
        }
    }

    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        int scrollItems = this.itemCount - this.menuSize;
        if (scrollItems > 0) {
            this.scrolled = (int)((double)this.scrolled - p_mouseScrolled_5_);
            this.scrolled = MathHelper.func_76125_a((int)this.scrolled, (int)0, (int)scrollItems);
        }
        return true;
    }

    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.scrollerPressed) {
            float amount = ((float)p_mouseDragged_3_ - (float)this.y - 13.5f) / ((float)this.height - 27.0f);
            amount = amount * (float)(this.itemCount - this.menuSize) + 0.5f;
            this.scrolled = MathHelper.func_76125_a((int)((int)amount), (int)0, (int)(this.itemCount - this.menuSize));
            return true;
        }
        return super.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }
}

