/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.inventory;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.Tag;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

public abstract class InventoryContainer
extends Container {
    protected final IWorldPosCallable worldPos;
    protected final IInventory inventory;
    private final int size;

    public InventoryContainer(ContainerType<? extends InventoryContainer> containerType, int id, PlayerInventory playerInventory, IWorldPosCallable worldPos, @Nonnull IInventory inventory, SelectorInfo ... selectorInfos) {
        this(containerType, id, worldPos, inventory, selectorInfos.length);
        if (inventory.func_70302_i_() < selectorInfos.length) {
            throw new IllegalArgumentException("Inventory size smaller than selector infos");
        }
        inventory.func_174889_b(playerInventory.field_70458_d);
        for (int i = 0; i < selectorInfos.length; ++i) {
            this.func_75146_a(new SelectorSlot(inventory, i, selectorInfos[i]){

                public void func_75220_a(@Nonnull ItemStack p_75220_1_, @Nonnull ItemStack p_75220_2_) {
                    super.func_75220_a(p_75220_1_, p_75220_2_);
                    InventoryContainer.this.func_75130_a(this.field_75224_c);
                }

                public boolean func_111238_b() {
                    return InventoryContainer.this.isSlotEnabled(this.field_75222_d);
                }
            });
        }
    }

    private InventoryContainer(ContainerType<? extends InventoryContainer> containerType, int id, IWorldPosCallable worldPos, IInventory inventory, int size) {
        super(containerType, id);
        this.worldPos = worldPos;
        this.inventory = inventory;
        this.size = size;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.inventory.func_174886_c(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerEntity, int index) {
        ItemStack result = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            result = slotStack.func_77946_l();
            if (index < this.size) {
                if (!this.func_75135_a(slotStack, this.size, 36 + this.size, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= this.size && index < 27 + this.size) {
                if (!this.func_75135_a(slotStack, 0, this.size, false) && slotStack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                if (!this.func_75135_a(slotStack, 27 + this.size, 36 + this.size, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 27 + this.size && index < 36 + this.size && !this.func_75135_a(slotStack, 0, 27 + this.size, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == result.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerEntity, slotStack);
        }
        return result;
    }

    protected void addPlayerSlots(PlayerInventory playerInventory, int baseX, int baseY) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, baseX + j * 18, baseY + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, baseX + i * 18, baseY + 58));
        }
    }

    protected void addPlayerSlots(PlayerInventory playerInventory) {
        this.addPlayerSlots(playerInventory, 8, 84);
    }

    protected boolean isSlotEnabled(int id) {
        return true;
    }

    public static class SelectorInfo {
        public final Predicate<ItemStack> predicate;
        public final int xDisplay;
        public final int yDisplay;
        public final int stackLimit;
        public final boolean inverted;
        @Nullable
        public final Pair<ResourceLocation, ResourceLocation> background;

        public SelectorInfo(Predicate<ItemStack> predicate, int x, int y, boolean inverted, int limit, @Nullable Pair<ResourceLocation, ResourceLocation> background) {
            this.predicate = predicate;
            this.xDisplay = x;
            this.yDisplay = y;
            this.stackLimit = limit;
            this.inverted = inverted;
            this.background = background;
        }

        public SelectorInfo(Item item, int x, int y) {
            this(item, x, y, false, 64, null);
        }

        public SelectorInfo(Item item, int x, int y, boolean inverted, int stackLimit, @Nullable Pair<ResourceLocation, ResourceLocation> background) {
            this((ItemStack itemStack) -> item.equals(itemStack.func_77973_b()), x, y, inverted, stackLimit, background);
        }

        public SelectorInfo(LazyOptional<Collection<Item>> lazyItemCollection, int x, int y, boolean inverted, int stackLimit, @Nullable Pair<ResourceLocation, ResourceLocation> background) {
            this((ItemStack itemStack) -> (Boolean)lazyItemCollection.map(list -> list.contains(itemStack.func_77973_b())).orElse((Object)false), x, y, inverted, stackLimit, background);
        }

        public SelectorInfo(Tag<Item> tag, int x, int y) {
            this(tag, x, y, false, 64, null);
        }

        public SelectorInfo(Tag<Item> tag, int x, int y, boolean inverted, int stackLimit, @Nullable Pair<ResourceLocation, ResourceLocation> background) {
            this((ItemStack itemStack) -> tag.func_199685_a_((Object)itemStack.func_77973_b()) || tag.func_199885_a().isEmpty(), x, y, inverted, stackLimit, background);
        }

        public SelectorInfo(Predicate<ItemStack> predicate, int x, int y) {
            this(predicate, x, y, false);
        }

        public SelectorInfo(Predicate<ItemStack> predicate, int x, int y, boolean inverted) {
            this(predicate, x, y, inverted, 64, null);
        }

        public SelectorInfo(Predicate<ItemStack> predicate, int x, int y, int stackLimit, @Nullable Pair<ResourceLocation, ResourceLocation> background) {
            this(predicate, x, y, false, stackLimit, background);
        }

        public boolean validate(ItemStack s) {
            boolean result = this.predicate.test(s);
            return result != this.inverted;
        }
    }

    public static class SelectorSlot
    extends Slot {
        private final SelectorInfo info;

        public SelectorSlot(IInventory inventoryIn, int index, SelectorInfo info) {
            super(inventoryIn, index, info.xDisplay, info.yDisplay);
            this.info = info;
        }

        public int func_178170_b(ItemStack stack) {
            return this.info.stackLimit;
        }

        public boolean func_75214_a(ItemStack stack) {
            return this.info.validate(stack);
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
            return this.info.background;
        }
    }
}

