/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.inventory;

import de.teamlapen.lib.lib.util.ItemStackUtil;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryHelper {
    public static ItemStack checkItems(IInventory inventory, Item[] items, int[] amounts, BiPredicate<Item, Item> compareFunction) {
        if (inventory.func_70302_i_() < amounts.length || items.length != amounts.length) {
            throw new IllegalArgumentException("There has to be one itemstack and amount value for each item");
        }
        for (int i = 0; i < items.length; ++i) {
            int actual;
            ItemStack stack = inventory.func_70301_a(i);
            int n = actual = !stack.func_190926_b() && compareFunction.test(stack.func_77973_b(), items[i]) ? stack.func_190916_E() : 0;
            if (actual >= amounts[i]) continue;
            return new ItemStack((IItemProvider)items[i], amounts[i] - actual);
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack checkItems(IInventory inventory, Item[] items, int[] amounts) {
        return InventoryHelper.checkItems(inventory, items, amounts, Object::equals);
    }

    public static void removeItems(IInventory inventory, int[] amounts) {
        if (inventory.func_70302_i_() < amounts.length) {
            throw new IllegalArgumentException("There has to be one itemstack value for each amount");
        }
        for (int i = 0; i < amounts.length; ++i) {
            inventory.func_70298_a(i, amounts[i]);
        }
    }

    @Nonnull
    public static LazyOptional<Pair<IItemHandler, TileEntity>> tryGetItemHandler(IBlockReader world, BlockPos pos, @Nullable Direction side) {
        TileEntity tile;
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().hasTileEntity(state) && (tile = world.func_175625_s(pos)) != null) {
            return tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(capability -> ImmutablePair.of((Object)capability, (Object)tile));
        }
        return LazyOptional.empty();
    }

    public static void writeInventoryToTag(CompoundNBT tag, Inventory inventory) {
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = inventory.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            listnbt.add((Object)itemstack.func_77955_b(new CompoundNBT()));
        }
        tag.func_218657_a("inventory", (INBT)listnbt);
    }

    public static void readInventoryFromTag(CompoundNBT tag, Inventory inventory) {
        ListNBT listnbt = tag.func_150295_c("inventory", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)listnbt.func_150305_b(i));
            if (itemstack.func_190926_b()) continue;
            inventory.func_174894_a(itemstack);
        }
    }

    public static boolean canMergeStacks(ItemStack stack1, ItemStack stack2, int invLimit) {
        return !stack1.func_190926_b() && ItemStackUtil.stackEqualExact(stack1, stack2) && stack1.func_77985_e() && stack1.func_190916_E() < stack1.func_77976_d() && stack1.func_190916_E() < invLimit;
    }

    public static void addStackToSlotWithoutCheck(IInventory inv, int slot, ItemStack addStack) {
        int newCount = addStack.func_190916_E();
        ItemStack existingStack = inv.func_70301_a(slot);
        int oldCount = existingStack.func_190916_E();
        int addAmount = Math.min(newCount, Math.min(inv.func_70297_j_() - oldCount, addStack.func_77976_d() - oldCount));
        if (addAmount == 0) {
            return;
        }
        if (existingStack.func_190926_b()) {
            existingStack = addStack.func_77946_l();
            existingStack.func_190920_e(0);
            if (addStack.func_77942_o()) {
                existingStack.func_77982_d(addStack.func_77978_p().func_74737_b());
            }
            inv.func_70299_a(slot, existingStack);
        }
        existingStack.func_190917_f(addAmount);
        addStack.func_190918_g(addAmount);
    }

    public static int getFirstSuitableSlotToAdd(NonNullList<ItemStack> inventory, ItemStack stack, int invLimit) {
        int i;
        if (!stack.func_77951_h() && stack.func_77985_e()) {
            for (i = 0; i < inventory.size(); ++i) {
                if (!InventoryHelper.canMergeStacks((ItemStack)inventory.get(i), stack, invLimit)) continue;
                return i;
            }
        }
        for (i = 0; i < inventory.size(); ++i) {
            if (!((ItemStack)inventory.get(i)).func_190926_b()) continue;
            return i;
        }
        return -1;
    }
}

