/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.advancements;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.advancements.AbstractCriterionTrigger;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TriggerFaction
extends AbstractCriterionTrigger<Instance> {
    public static final ResourceLocation ID = new ResourceLocation("vampirism", "faction");
    private static final Logger LOGGER = LogManager.getLogger();

    public TriggerFaction() {
        super(ID, Listeners::new);
    }

    public static Instance builder(@Nullable IPlayableFaction<?> faction, int level) {
        return new Instance(faction, level);
    }

    @Nonnull
    public Instance deserializeInstance(JsonObject json, @Nonnull JsonDeserializationContext context) {
        IPlayableFaction faction = null;
        if (json.has("faction")) {
            ResourceLocation id = new ResourceLocation(json.get("faction").getAsString());
            IFaction faction1 = VampirismAPI.factionRegistry().getFactionByID(id);
            if (!(faction1 instanceof IPlayableFaction)) {
                LOGGER.warn("Given faction name does not exist or is not a playable faction: {}", (Object)id);
            } else {
                faction = (IPlayableFaction)faction1;
            }
        }
        int level = json.has("level") ? json.get("level").getAsInt() : 1;
        return new Instance(faction, level);
    }

    public void trigger(ServerPlayerEntity playerMP, IPlayableFaction<?> faction, int level) {
        Listeners listeners = (Listeners)this.listenersForPlayers.get(playerMP.func_192039_O());
        if (listeners != null) {
            listeners.trigger(faction, level);
        }
    }

    @Override
    public void func_192167_a(@Nonnull PlayerAdvancements playerAdvancementsIn) {
        this.listenersForPlayers.remove(playerAdvancementsIn);
    }

    static class Listeners
    extends AbstractCriterionTrigger.GenericListeners<Instance> {
        Listeners(PlayerAdvancements playerAdvancementsIn) {
            super(playerAdvancementsIn);
        }

        void trigger(IPlayableFaction<?> faction, int level) {
            List list = null;
            for (ICriterionTrigger.Listener listener : this.playerListeners) {
                if (!((Instance)listener.func_192158_a()).trigger(faction, level)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    static class Instance
    extends CriterionInstance {
        @Nullable
        private final IPlayableFaction<?> faction;
        private final int level;

        Instance(@Nullable IPlayableFaction<?> faction, int level) {
            super(ID);
            this.faction = faction;
            this.level = level;
        }

        public boolean trigger(IPlayableFaction<?> faction, int level) {
            if (this.faction == null || this.faction.equals(faction)) {
                return level >= this.level;
            }
            return false;
        }

        @Nonnull
        public JsonElement func_200288_b() {
            JsonObject json = new JsonObject();
            json.addProperty("faction", this.faction == null ? "null" : this.faction.getID().toString());
            json.addProperty("level", (Number)this.level);
            return json;
        }
    }
}

