/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.actions;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IAction;
import javax.annotation.Nonnull;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class DefaultAction<T extends IFactionPlayer>
extends ForgeRegistryEntry<IAction>
implements IAction {
    private final IPlayableFaction<T> faction;
    private String translationKey;

    @Deprecated
    public DefaultAction(IPlayableFaction<T> faction) {
        this.faction = faction;
    }

    public DefaultAction() {
        this.faction = null;
    }

    public boolean canBeUsedBy(T player) {
        return true;
    }

    @Override
    public IAction.PERM canUse(IFactionPlayer player) {
        if (!this.isEnabled()) {
            return IAction.PERM.DISABLED;
        }
        if (this.getFaction().getFactionPlayerInterface().isInstance(player)) {
            return this.canBeUsedBy(player) ? IAction.PERM.ALLOWED : IAction.PERM.DISALLOWED;
        }
        throw new IllegalArgumentException("Faction player instance is of wrong class " + player.getClass() + " instead of " + this.getFaction().getFactionPlayerInterface());
    }

    @Override
    @Nonnull
    public IPlayableFaction getFaction() {
        return this.faction;
    }

    @Override
    public String getTranslationKey() {
        return this.translationKey == null ? (this.translationKey = "action." + this.getRegistryName().func_110624_b() + "." + this.getRegistryName().func_110623_a()) : this.translationKey;
    }

    public abstract boolean isEnabled();

    @Override
    public boolean onActivated(IFactionPlayer player) {
        if (this.getFaction().getFactionPlayerInterface().isInstance(player)) {
            return this.activate(player);
        }
        throw new IllegalArgumentException("Faction player instance is of wrong class " + player.getClass() + " instead of " + this.getFaction().getFactionPlayerInterface());
    }

    public String toString() {
        return this.getRegistryName() + " (" + this.getClass().getSimpleName() + ")";
    }

    protected abstract boolean activate(T var1);
}

