/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.task;

import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import de.teamlapen.vampirism.api.entity.player.task.TaskUnlocker;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class Task
extends ForgeRegistryEntry<Task> {
    @Nonnull
    private final Variant variant;
    @Nullable
    private final IPlayableFaction<?> faction;
    @Nonnull
    private final TaskRequirement requirements;
    @Nonnull
    private final TaskReward rewards;
    @Nonnull
    private final TaskUnlocker[] unlocker;
    private final boolean useDescription;
    @Nullable
    private String translationKey;
    @Nullable
    private ITextComponent translation;
    @Nullable
    private String descKey;
    @Nullable
    private ITextComponent desc;

    public Task(@Nonnull Variant variant, @Nullable IPlayableFaction<?> faction, @Nonnull TaskRequirement requirements, @Nonnull TaskReward rewards, @Nonnull TaskUnlocker[] unlocker, boolean useDescription) {
        this.variant = variant;
        this.faction = faction;
        this.requirements = requirements;
        this.useDescription = useDescription;
        this.rewards = rewards;
        this.unlocker = unlocker;
    }

    public boolean isUnique() {
        return this.variant == Variant.UNIQUE;
    }

    @Nullable
    public IPlayableFaction<?> getFaction() {
        return this.faction;
    }

    @Nonnull
    public TaskRequirement getRequirement() {
        return this.requirements;
    }

    @Nonnull
    public TaskReward getReward() {
        return this.rewards;
    }

    @Nonnull
    public TaskUnlocker[] getUnlocker() {
        return this.unlocker;
    }

    @Nonnull
    public String getTranslationKey() {
        return this.translationKey != null ? this.translationKey : (this.translationKey = Util.func_200697_a((String)"task", (ResourceLocation)this.getRegistryName()));
    }

    @Nonnull
    public String getDescriptionKey() {
        return this.descKey != null ? this.descKey : (this.descKey = (this.translationKey != null ? this.translationKey : this.getTranslationKey()) + ".desc");
    }

    @Nonnull
    public ITextComponent getTranslation() {
        return (this.translation != null ? this.translation : (this.translation = new TranslationTextComponent(this.getTranslationKey(), new Object[0]))).func_150259_f();
    }

    @Nonnull
    public ITextComponent getDescription() {
        return (this.desc != null ? this.desc : (this.desc = new TranslationTextComponent(this.getDescriptionKey(), new Object[0]))).func_150259_f();
    }

    public boolean useDescription() {
        return this.useDescription;
    }

    public static enum Variant {
        REPEATABLE,
        UNIQUE;

    }
}

