/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.entity.player.task;

import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;

public class TaskRequirement {
    private final Map<Type, List<Requirement<?>>> requirements;
    private final int size;
    private final boolean hasStatBasedReq;

    public TaskRequirement(Map<Type, List<Requirement<?>>> requirements) {
        this.requirements = requirements;
        this.size = requirements.values().stream().mapToInt(List::size).sum();
        this.hasStatBasedReq = requirements.keySet().stream().anyMatch(Type::isStatBased);
    }

    public Map<Type, List<Requirement<?>>> requirements() {
        return this.requirements;
    }

    public int size() {
        return this.size;
    }

    public void removeRequirement(IFactionPlayer<?> player) {
        for (Type type : this.requirements.keySet()) {
            for (Requirement<?> requirement : this.requirements.get((Object)type)) {
                requirement.removeRequirement(player);
            }
        }
    }

    public List<Requirement<?>> getAll() {
        return this.requirements.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean isHasStatBasedReq() {
        return this.hasStatBasedReq;
    }

    public static enum Type {
        STATS(true),
        ITEMS(false),
        ENTITY(true),
        ENTITY_TAG(true),
        BOOLEAN(false);

        private boolean statBased;

        private Type(boolean statBased) {
            this.statBased = statBased;
        }

        public boolean isStatBased() {
            return this.statBased;
        }
    }

    public static interface Requirement<T> {
        @Nonnull
        default public Type getType() {
            return Type.BOOLEAN;
        }

        @Nonnull
        public T getStat(IFactionPlayer<?> var1);

        default public int getAmount(IFactionPlayer<?> player) {
            return 1;
        }

        default public void removeRequirement(IFactionPlayer<?> player) {
        }

        @Nonnull
        public ResourceLocation getId();
    }
}

