/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.event;

import de.teamlapen.vampirism.api.entity.IVillageCaptureEntity;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.world.ITotem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class VampirismVillageEvent
extends Event {
    protected final ITotem totem;

    public VampirismVillageEvent(ITotem totem) {
        this.totem = totem;
    }

    @Nullable
    public IFaction getCapturingFaction() {
        return this.totem.getCapturingFaction();
    }

    @Nullable
    public IFaction getControllingFaction() {
        return this.totem.getControllingFaction();
    }

    @Nonnull
    public AxisAlignedBB getVillageArea() {
        return this.totem.getVillageArea();
    }

    @Nonnull
    public AxisAlignedBB getVillageAreaReduced() {
        return this.totem.getVillageAreaReduced();
    }

    public World getWorld() {
        return this.totem.getWorld();
    }

    public ITotem getTotem() {
        return this.totem;
    }

    public static class UpdateBoundingBox
    extends VampirismVillageEvent {
        @Nonnull
        private final MutableBoundingBox bb;

        public UpdateBoundingBox(ITotem totem, @Nonnull MutableBoundingBox bb) {
            super(totem);
            this.bb = bb;
        }

        @Nonnull
        public MutableBoundingBox getBoundingBox() {
            return this.bb;
        }
    }

    @Event.HasResult
    public static class InitiateCapture
    extends VampirismVillageEvent {
        @Nonnull
        private final IFaction<?> capturingFaction;
        private String message;

        public InitiateCapture(ITotem totem, @Nonnull IFaction<?> capturingFaction) {
            super(totem);
            this.capturingFaction = capturingFaction;
        }

        @Override
        @Nonnull
        public IFaction<?> getCapturingFaction() {
            return this.capturingFaction;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public static class ReplaceBlock
    extends VampirismVillageEvent {
        @Nonnull
        private final BlockState state;
        @Nonnull
        private final BlockPos pos;

        public ReplaceBlock(ITotem totem, @Nonnull BlockState b, @Nonnull BlockPos pos) {
            super(totem);
            this.state = b;
            this.pos = pos;
        }

        @Nonnull
        public BlockState getState() {
            return this.state;
        }

        @Nonnull
        public BlockPos getBlockPos() {
            return this.pos;
        }
    }

    @Deprecated
    public static class SpawnCaptureEntity
    extends VampirismVillageEvent {
        private EntityType<? extends MobEntity> entity;

        public SpawnCaptureEntity(ITotem totem) {
            super(totem);
        }

        public void setEntity(EntityType<? extends MobEntity> entity) {
            this.entity = entity;
        }

        @Nullable
        public EntityType<? extends MobEntity> getEntity() {
            return this.entity;
        }
    }

    @Event.HasResult
    public static class VillagerCaptureFinishParent
    extends VampirismVillageEvent {
        @Nonnull
        private final List<VillagerEntity> villager;
        private final boolean forced;

        public VillagerCaptureFinishParent(ITotem totem, @Nonnull List<VillagerEntity> villagerIn, boolean forced) {
            super(totem);
            this.villager = villagerIn;
            this.forced = forced;
        }

        @Nonnull
        public List<VillagerEntity> getVillager() {
            return this.villager;
        }

        public boolean isForced() {
            return this.forced;
        }

        public static class Pre
        extends VillagerCaptureFinishParent {
            public Pre(ITotem totem, @Nonnull List<VillagerEntity> villagerIn, boolean forced) {
                super(totem, villagerIn, forced);
            }
        }

        public static class Post
        extends VillagerCaptureFinishParent {
            public Post(ITotem totem, @Nonnull List<VillagerEntity> villagerIn, boolean forced) {
                super(totem, villagerIn, forced);
            }
        }
    }

    @Event.HasResult
    public static class VillagerCaptureFinish
    extends VillagerCaptureFinishParent.Pre {
        public VillagerCaptureFinish(ITotem totem, @Nonnull List<VillagerEntity> villagerIn, boolean forced) {
            super(totem, villagerIn, forced);
        }
    }

    @Cancelable
    public static class MakeAggressive
    extends VampirismVillageEvent {
        private final VillagerEntity oldVillager;
        @Nullable
        private IVillageCaptureEntity captureVillager;

        public MakeAggressive(ITotem totem, @Nonnull VillagerEntity villager) {
            super(totem);
            this.oldVillager = villager;
        }

        @Nullable
        public IVillageCaptureEntity getAggressiveVillager() {
            return this.captureVillager;
        }

        public void setAggressiveVillager(@Nullable IVillageCaptureEntity captureVillager) {
            this.captureVillager = captureVillager;
        }

        public VillagerEntity getOldVillager() {
            return this.oldVillager;
        }
    }

    @Event.HasResult
    public static class SpawnNewVillager
    extends VampirismVillageEvent {
        @Nullable
        private final MobEntity oldEntity;
        @Nullable
        private VillagerEntity newVillager;
        private boolean replace;
        private boolean willBeConverted;

        public SpawnNewVillager(ITotem totem, @Nullable MobEntity oldEntity, @Nonnull VillagerEntity newVillager, boolean replace, boolean willBeConverted) {
            super(totem);
            this.oldEntity = oldEntity;
            this.newVillager = newVillager;
            this.replace = replace;
            this.willBeConverted = willBeConverted;
        }

        @Nullable
        public VillagerEntity getNewVillager() {
            return this.newVillager;
        }

        public void setNewVillager(@Nullable VillagerEntity newVillager) {
            this.newVillager = newVillager;
        }

        @Nullable
        public MobEntity getOldEntity() {
            return this.oldEntity;
        }

        public boolean isWillBeConverted() {
            return this.willBeConverted;
        }

        public boolean isReplace() {
            return this.replace;
        }

        public void setWillBeConverted(boolean willBeConverted) {
            this.willBeConverted = willBeConverted;
        }

        public IFaction<?> getFaction() {
            return this.totem.getControllingFaction();
        }
    }
}

