/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api.general;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import de.teamlapen.vampirism.api.VReference;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.FluidStack;

public class BloodConversionRegistry {
    @Nonnull
    private static final Map<ResourceLocation, Integer> items = Maps.newHashMap();
    @Nonnull
    private static final Map<ResourceLocation, Integer> fluids = Maps.newHashMap();
    @Nonnull
    private static final Map<ResourceLocation, Integer> items_calculated = Maps.newHashMap();
    @Nonnull
    private static final Set<ResourceLocation> items_blacklist = Sets.newHashSet();
    private static int fluidDivider = 100;
    private static int itemMultiplier = 100;

    public static void applyNewFluidResources(Map<ResourceLocation, Integer> values, int divider) {
        fluids.clear();
        fluidDivider = divider;
        fluids.putAll(values);
    }

    public static void applyNewItemResources(Map<ResourceLocation, Integer> values, int multiplier) {
        items.clear();
        itemMultiplier = multiplier;
        for (Map.Entry<ResourceLocation, Integer> value : values.entrySet()) {
            if (value.getValue() != 0) {
                items.put(value.getKey(), value.getValue());
                continue;
            }
            items_blacklist.add(value.getKey());
        }
    }

    public static void applyNewItemCalculated(Map<ResourceLocation, Integer> values) {
        items_calculated.putAll(values);
    }

    public static Map<ResourceLocation, Integer> getItemValues() {
        return new ConcurrentHashMap<ResourceLocation, Integer>(items);
    }

    public static Map<ResourceLocation, Integer> getFluidValues() {
        return new ConcurrentHashMap<ResourceLocation, Integer>(fluids);
    }

    public static Map<ResourceLocation, Integer> getItemValuesCalculated() {
        return new ConcurrentHashMap<ResourceLocation, Integer>(items_calculated);
    }

    public static int getFluidDivider() {
        return fluidDivider;
    }

    public static int getItemMultiplier() {
        return itemMultiplier;
    }

    public static int getImpureBloodValue(@Nonnull Item item) {
        if (items.containsKey(item.getRegistryName()) || items_calculated.containsKey(item.getRegistryName())) {
            return items.containsKey(item.getRegistryName()) ? items.get(item.getRegistryName()) * itemMultiplier : items_calculated.get(item.getRegistryName()) * itemMultiplier;
        }
        return 0;
    }

    public static boolean canBeConverted(@Nonnull Item item) {
        int value;
        if (items.containsKey(item.getRegistryName()) || items_calculated.containsKey(item.getRegistryName())) {
            return true;
        }
        if (items_blacklist.contains(item.getRegistryName())) {
            return false;
        }
        if (item.func_219971_r() && item.func_219967_s().func_221467_c() && (value = MathHelper.func_76125_a((int)(item.getRegistryName().func_110623_a().contains("cooked") ? 0 : item.func_219967_s().func_221466_a() / 2), (int)0, (int)5)) > 0) {
            items_calculated.put(item.getRegistryName(), value);
            return true;
        }
        items_blacklist.add(item.getRegistryName());
        return false;
    }

    public static float getBloodValue(@Nonnull FluidStack fluid) {
        if (fluids.containsKey(fluid.getFluid().getRegistryName())) {
            return (float)fluids.get(fluid.getFluid().getRegistryName()).intValue() / (float)fluidDivider;
        }
        return 0.0f;
    }

    public static boolean existsBloodValue(@Nonnull Fluid fluid) {
        return fluids.containsKey(fluid.getRegistryName());
    }

    public static FluidStack getBloodFromFluid(@Nonnull FluidStack fluid) {
        if (fluid.getFluid().func_207187_a(VReference.blood_fluid)) {
            return fluid;
        }
        return new FluidStack(VReference.blood_fluid, (int)(BloodConversionRegistry.getBloodValue(fluid) * (float)fluid.getAmount()));
    }
}

