/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.tileentity.BloodContainerTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BloodContainerBlock
extends VampirismBlockContainer {
    public static final String regName = "blood_container";
    protected static final VoxelShape containerShape = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final Logger LOGGER = LogManager.getLogger();
    @ObjectHolder(value="vampirism:blood_container")
    public static final Item item = (Item)UtilLib.getNull();

    public BloodContainerBlock() {
        super(regName, Block.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(1.0f));
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new BloodContainerTileEntity();
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        super.func_149666_a(group, items);
        ItemStack stack = new ItemStack((IItemProvider)this, 1);
        FluidStack fluid = new FluidStack(ModFluids.blood, 12600);
        stack.func_77983_a("fluid", (INBT)fluid.writeToNBT(new CompoundNBT()));
        items.add((Object)stack);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return containerShape;
    }

    public static FluidStack getFluidFromItemStack(ItemStack stack) {
        if (stack.func_77973_b() == item) {
            if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("fluid", 10)) {
                CompoundNBT fluidTag = stack.func_77978_p().func_74775_l("fluid");
                FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundNBT)fluidTag);
                return fluidStack;
            }
            return new FluidStack(ModFluids.blood, 0);
        }
        return FluidStack.EMPTY;
    }

    public static void writeFluidToItemStack(ItemStack stack, FluidStack fluid) {
        if (fluid.isEmpty()) {
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fluid")) {
                stack.func_77978_p().func_82580_o("fluid");
            }
        } else {
            stack.func_77983_a("fluid", (INBT)fluid.writeToNBT(new CompoundNBT()));
        }
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack heldStack) {
        FluidStack fluid;
        ItemStack stack = new ItemStack((IItemProvider)ModBlocks.blood_container, 1);
        if (te != null && !(fluid = ((BloodContainerTileEntity)te).getFluid()).isEmpty() && fluid.getAmount() >= 100) {
            BloodContainerBlock.writeFluidToItemStack(stack, fluid);
        }
        BloodContainerBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult hit) {
        if (!FluidUtil.interactWithFluidHandler((PlayerEntity)playerIn, (Hand)hand, (World)worldIn, (BlockPos)pos, (Direction)hit.func_216354_b()) && playerIn.func_184586_b(hand).func_77973_b().equals(Items.field_151069_bo) && ((Boolean)VampirismConfig.SERVER.autoConvertGlassBottles.get()).booleanValue()) {
            FluidUtil.getFluidHandler((World)worldIn, (BlockPos)pos, (Direction)hit.func_216354_b()).ifPresent(fluidHandler -> {
                if (fluidHandler.getFluidInTank(0).getFluid().equals(ModFluids.blood)) {
                    ItemStack glass = playerIn.func_184586_b(hand);
                    ItemStack bloodBottle = new ItemStack((IItemProvider)ModItems.blood_bottle, 1);
                    playerIn.func_184611_a(hand, bloodBottle);
                    bloodBottle = FluidUtil.tryFillContainer((ItemStack)bloodBottle, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, (PlayerEntity)playerIn, (boolean)true).getResult();
                    if (glass.func_190916_E() > 1) {
                        glass.func_190918_g(1);
                        playerIn.func_184611_a(hand, glass);
                        playerIn.func_191521_c(bloodBottle);
                    } else {
                        playerIn.func_184611_a(hand, bloodBottle);
                    }
                }
            });
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tile;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        FluidStack fluid = BloodContainerBlock.getFluidFromItemStack(stack);
        if (!stack.func_190926_b() && (tile = worldIn.func_175625_s(pos)) instanceof BloodContainerTileEntity) {
            ((BloodContainerTileEntity)tile).setFluidStack(fluid);
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT nbt;
        FluidStack fluid;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("fluid") && (fluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)(nbt = stack.func_77978_p().func_74775_l("fluid")))) != null) {
            tooltip.add(new TranslationTextComponent(fluid.getTranslationKey(), new Object[0]).func_150258_a(": ").func_150258_a(fluid.getAmount() + "mB").func_211708_a(TextFormatting.DARK_RED));
        }
    }
}

