/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ChurchAltarBlock
extends HorizontalBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final String regName = "church_altar";
    private static final VoxelShape SHAPEX = ChurchAltarBlock.makeShape();
    private static final VoxelShape SHAPEZ = UtilLib.rotateShape(SHAPEX, UtilLib.RotationAmount.NINETY);

    private static VoxelShape makeShape() {
        VoxelShape a = Block.func_208617_a((double)1.0, (double)0.0, (double)5.0, (double)15.0, (double)1.0, (double)12.0);
        VoxelShape b = Block.func_208617_a((double)7.0, (double)1.0, (double)7.0, (double)9.0, (double)12.0, (double)11.0);
        VoxelShape c = Block.func_208617_a((double)1.0, (double)9.0, (double)3.0, (double)15.0, (double)14.0, (double)13.0);
        VoxelShape r = VoxelShapes.func_197872_a((VoxelShape)a, (VoxelShape)b);
        return VoxelShapes.func_197872_a((VoxelShape)r, (VoxelShape)c);
    }

    public ChurchAltarBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(0.5f));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH));
        this.setRegistryName("vampirism", regName);
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState blockState, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        Direction dir = (Direction)blockState.func_177229_b((IProperty)FACING);
        if (dir == Direction.NORTH || dir == Direction.SOUTH) {
            return SHAPEX;
        }
        return SHAPEZ;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)ctx.func_195992_f().func_176734_d());
    }

    public boolean func_220081_d(BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos) {
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!player.func_70089_S()) {
            return ActionResultType.PASS;
        }
        FactionPlayerHandler handler = FactionPlayerHandler.get(player);
        ItemStack heldItem = player.func_184586_b(hand);
        if (handler.isInFaction(VReference.VAMPIRE_FACTION)) {
            VampirismMod.proxy.displayRevertBackScreen();
            return ActionResultType.SUCCESS;
        }
        if (!heldItem.func_190926_b()) {
            if (((Object)((Object)ModItems.holy_salt_water)).equals(heldItem.func_77973_b())) {
                if (world.field_72995_K) {
                    return ActionResultType.SUCCESS;
                }
                boolean enhanced = handler.isInFaction(VReference.HUNTER_FACTION) && handler.getCurrentFactionPlayer().map(s -> s.getSkillHandler()).map(s -> s.isSkillEnabled(HunterSkills.holy_water_enhanced)).orElse(false) != false;
                ItemStack newStack = new ItemStack((IItemProvider)(enhanced ? ModItems.holy_water_bottle_enhanced : ModItems.holy_water_bottle_normal), heldItem.func_190916_E());
                player.func_184611_a(hand, newStack);
                return ActionResultType.SUCCESS;
            }
            if (((Object)((Object)ModItems.pure_salt)).equals(heldItem.func_77973_b())) {
                if (world.field_72995_K) {
                    return ActionResultType.SUCCESS;
                }
                player.func_184611_a(hand, new ItemStack((IItemProvider)ModItems.holy_salt, heldItem.func_190916_E()));
            }
        }
        return ActionResultType.PASS;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
    }
}

