/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.blocks.VampirismBlock;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.potion.PotionSanguinare;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MedChairBlock
extends VampirismBlock {
    public static final EnumProperty<EnumPart> PART = EnumProperty.func_177709_a((String)"part", EnumPart.class);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private static final String name = "med_chair";
    private final VoxelShape SHAPE_TOP;
    private final VoxelShape SHAPE_BOTTOM;

    public MedChairBlock() {
        super(name, Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(1.0f));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a(PART, (Comparable)((Object)EnumPart.TOP)));
        this.SHAPE_TOP = MedChairBlock.func_208617_a((double)2.0, (double)6.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
        this.SHAPE_BOTTOM = MedChairBlock.func_208617_a((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)10.0, (double)16.0);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_196010_d());
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)ModItems.item_med_chair);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return state.func_177229_b(PART) == EnumPart.BOTTOM ? this.SHAPE_BOTTOM : this.SHAPE_TOP;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        boolean garlic = stack.func_77973_b().equals((Object)ModItems.injection_garlic);
        boolean sanguinare = stack.func_77973_b().equals((Object)ModItems.injection_sanguinare);
        if ((garlic || sanguinare) && player.func_70089_S()) {
            FactionPlayerHandler handler = FactionPlayerHandler.get(player);
            IPlayableFaction<IFactionPlayer<?>> faction = handler.getCurrentFaction();
            boolean used = false;
            if (garlic) {
                if (handler.canJoin(VReference.HUNTER_FACTION)) {
                    if (world.field_72995_K) {
                        VampirismMod.proxy.renderScreenFullColor(4, 30, -1145324545);
                    } else {
                        handler.joinFaction(VReference.HUNTER_FACTION);
                        player.func_195064_c(new EffectInstance(ModEffects.poison, 200, 1));
                    }
                    used = true;
                } else if (faction != null && !world.field_72995_K) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.med_chair_other_faction", new Object[]{faction.getName()}));
                }
            } else if (sanguinare) {
                if (VReference.HUNTER_FACTION.equals(faction)) {
                    VampirismMod.proxy.displayRevertBackScreen();
                    used = true;
                } else if (faction == null) {
                    if (handler.canJoin(VReference.VAMPIRE_FACTION)) {
                        if (((Boolean)VampirismConfig.SERVER.disableFangInfection.get()).booleanValue()) {
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("text.vampirism.deactivated_by_serveradmin", new Object[0]), true);
                        } else {
                            PotionSanguinare.addRandom((LivingEntity)player, true);
                            player.func_195064_c(new EffectInstance(ModEffects.poison, 60));
                            used = true;
                        }
                    }
                } else if (VReference.VAMPIRE_FACTION.equals(faction)) {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.already_vampire", new Object[0]));
                }
            }
            if (used) {
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    player.field_71071_by.func_184437_d(stack);
                }
            }
        } else if (world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("text.vampirism.need_item_to_use", new Object[]{new TranslationTextComponent(new ItemStack((IItemProvider)ModItems.injection_garlic).func_77977_a(), new Object[0])}));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, Blocks.field_150350_a.func_176223_P(), te, stack);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        EnumPart part = (EnumPart)((Object)state.func_177229_b(PART));
        Direction dir = (Direction)state.func_177229_b((IProperty)FACING);
        BlockPos other = state.func_177229_b(PART) == EnumPart.TOP ? pos.func_177972_a(dir) : pos.func_177972_a(dir.func_176734_d());
        BlockState otherState = worldIn.func_180495_p(other);
        if (otherState.func_177230_c() == this && otherState.func_177229_b(PART) != part) {
            worldIn.func_180501_a(other, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_217378_a(player, 2001, other, Block.func_196246_j((BlockState)otherState));
            if (!worldIn.field_72995_K && !player.func_184812_l_()) {
                ItemStack itemstack = player.func_184614_ca();
                MedChairBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)itemstack);
                MedChairBlock.func_220054_a((BlockState)otherState, (World)worldIn, (BlockPos)other, null, (Entity)player, (ItemStack)itemstack);
            }
            player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, PART});
    }

    public static enum EnumPart implements IStringSerializable
    {
        TOP("top", 0),
        BOTTOM("bottom", 1);

        public final String name;
        public final int meta;

        public static EnumPart fromMeta(int meta) {
            if (meta == 1) {
                return BOTTOM;
            }
            return TOP;
        }

        private EnumPart(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

