/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModTiles;
import de.teamlapen.vampirism.tileentity.TotemTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TotemTopBlock
extends ContainerBlock {
    private static final List<TotemTopBlock> blocks = new ArrayList<TotemTopBlock>();
    private static final VoxelShape shape = TotemTopBlock.makeShape();
    private final boolean crafted;
    public final ResourceLocation faction;

    public static List<TotemTopBlock> getBlocks() {
        return Collections.unmodifiableList(blocks);
    }

    private static VoxelShape makeShape() {
        VoxelShape a = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
        VoxelShape b = Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0);
        return VoxelShapes.func_197872_a((VoxelShape)a, (VoxelShape)b);
    }

    public TotemTopBlock(boolean crafted, ResourceLocation faction) {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(12.0f, 2000.0f).func_200947_a(SoundType.field_185851_d));
        this.faction = faction;
        this.crafted = crafted;
        blocks.add(this);
    }

    public boolean canEntityDestroy(BlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return false;
    }

    public float func_149638_a() {
        return Float.MAX_VALUE;
    }

    @Nullable
    public TileEntity func_196283_a_(@Nonnull IBlockReader worldIn) {
        return ModTiles.totem.func_200968_a();
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return shape;
    }

    public boolean isCrafted() {
        return this.crafted;
    }

    public boolean func_220081_d(BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos) {
        return false;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.field_72995_K) {
            return;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TotemTileEntity) {
            ((TotemTileEntity)tile).updateTileStatus();
            worldIn.func_175641_c(pos, (Block)this, 1, 0);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TotemTileEntity t = this.getTile(world, pos);
        if (t != null && world.func_180495_p(pos.func_177977_b()).func_177230_c().equals((Object)ModBlocks.totem_base)) {
            t.initiateCapture(player);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, IFluidState fluid) {
        TotemTileEntity tile = this.getTile(world, pos);
        if (tile != null && !tile.canPlayerRemoveBlock(player)) {
            return false;
        }
        if (super.removedByPlayer(state, world, pos, player, willHarvest, fluid)) {
            if (tile != null && tile.getControllingFaction() != null) {
                tile.notifyNearbyPlayers((ITextComponent)new TranslationTextComponent("text.vampirism.village.village_abandoned", new Object[0]));
            }
            return true;
        }
        return false;
    }

    @Nullable
    private TotemTileEntity getTile(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TotemTileEntity) {
            return (TotemTileEntity)tile;
        }
        return null;
    }

    public void func_196243_a(BlockState state, @Nonnull World worldIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(newState.func_177230_c() instanceof TotemTopBlock)) {
            worldIn.func_175713_t(pos);
        }
    }
}

