/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.google.common.collect.Lists;
import de.teamlapen.lib.lib.util.UtilLib;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AppearanceScreen<T extends LivingEntity>
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("vampirism", "textures/gui/appearance.png");
    protected final T entity;
    protected final int xSize = 256;
    protected final int ySize = 177;
    private final List<Button> buttons = Lists.newArrayList();
    protected int guiLeft;
    protected int guiTop;
    @Nullable
    private final Screen backScreen;

    public AppearanceScreen(ITextComponent titleIn, T entity, @Nullable Screen backScreen) {
        super(titleIn);
        this.entity = entity;
        this.backScreen = backScreen;
    }

    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        for (Button button : this.buttons) {
            if (!button.visible || !button.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_)) continue;
            return true;
        }
        return false;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.renderGuiBackground();
        this.drawTitle();
        InventoryScreen.func_228187_a_((int)(this.guiLeft + 200), (int)(this.guiTop + 145), (int)60, (float)((float)(this.guiLeft + 200) - (float)mouseX), (float)((float)(this.guiTop + 45) - (float)mouseY), this.entity);
        super.render(mouseX, mouseY, partialTicks);
        for (Button button : this.buttons) {
            button.render(mouseX, mouseY, partialTicks);
        }
    }

    protected void init() {
        this.buttons.clear();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.addButton((Widget)new Button(this.guiLeft + this.xSize - 80 - 10, this.guiTop + 152, 80, 20, UtilLib.translate("gui.done", new Object[0]), context -> this.onClose()));
        if (this.backScreen != null) {
            this.addButton((Widget)new Button(this.guiLeft + 10, this.guiTop + 152, 80, 20, UtilLib.translate("gui.back", new Object[0]), context -> this.minecraft.func_147108_a(this.backScreen)));
        }
    }

    protected void renderGuiBackground() {
        this.minecraft.func_110434_K().func_110577_a(BACKGROUND);
        AppearanceScreen.blit((int)this.guiLeft, (int)this.guiTop, (int)this.getBlitOffset(), (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)256, (int)300);
    }

    private void drawTitle() {
        String title = this.title.func_150254_d();
        this.font.func_175063_a(title, (float)(this.guiLeft + 15), (float)(this.guiTop + 5), -1);
    }
}

