/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import de.teamlapen.lib.lib.client.gui.ScrollableListButton;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.gui.AppearanceScreen;
import de.teamlapen.vampirism.client.render.entities.HunterMinionRenderer;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.network.AppearancePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class HunterMinionAppearanceScreen
extends AppearanceScreen<HunterMinionEntity> {
    private static final ITextComponent NAME = new TranslationTextComponent("gui.vampirism.minion_appearance", new Object[0]);
    private int skinType;
    private int hatType;
    private boolean useLordSkin;
    private ScrollableListButton skinList;
    private ScrollableListButton hatList;
    private ExtendedButton skinButton;
    private ExtendedButton hatButton;
    private CheckboxButton useLordSkinButton;
    private TextFieldWidget nameWidget;

    public HunterMinionAppearanceScreen(HunterMinionEntity minion, Screen backScreen) {
        super(NAME, minion, backScreen);
    }

    public void onClose() {
        String name = this.nameWidget.func_146179_b();
        if (name.isEmpty()) {
            name = new TranslationTextComponent("text.vampirism.minion", new Object[0]).toString() + ((HunterMinionEntity)this.entity).getMinionId().orElse(0);
        }
        VampirismMod.dispatcher.sendToServer(new AppearancePacket(((HunterMinionEntity)this.entity).func_145782_y(), name, this.skinType, this.hatType, this.useLordSkin ? 1 : 0));
        super.onClose();
    }

    @Override
    protected void init() {
        super.init();
        this.nameWidget = (TextFieldWidget)this.addButton((Widget)new TextFieldWidget(this.font, this.guiLeft + 21, this.guiTop + 29, 98, 12, UtilLib.translate("gui.vampirism.minion_appearance.name", new Object[0])));
        this.nameWidget.func_146180_a(((HunterMinionEntity)this.entity).getMinionData().map(MinionData::getName).orElse("Minion"));
        this.nameWidget.func_146204_h(-1);
        this.nameWidget.func_146193_g(-1);
        this.nameWidget.func_146203_f(15);
        this.nameWidget.func_212954_a(this::onNameChanged);
        this.skinType = ((HunterMinionEntity)this.entity).getHunterType();
        this.hatType = ((HunterMinionEntity)this.entity).getHatType();
        this.useLordSkin = ((HunterMinionEntity)this.entity).shouldRenderLordSkin();
        this.skinList = (ScrollableListButton)this.addButton((Widget)new ScrollableListButton(this.guiLeft + 20, this.guiTop + 43 + 19, 99, 5, ((HunterMinionRenderer)Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)this.entity)).getTextureLength(), null, UtilLib.translate("gui.vampirism.minion_appearance.skin", new Object[0]), this::skin, false));
        this.hatList = (ScrollableListButton)this.addButton((Widget)new ScrollableListButton(this.guiLeft + 20, this.guiTop + 64 + 19, 99, 3, 3, null, UtilLib.translate("gui.vampirism.minion_appearance.hat", new Object[0]), this::hat, false));
        this.skinButton = (ExtendedButton)this.addButton((Widget)new ExtendedButton(this.skinList.x, this.skinList.y - 20, this.skinList.getWidth() + 1, 20, "", b -> this.setSkinListVisibility(!this.skinList.visible)));
        this.hatButton = (ExtendedButton)this.addButton((Widget)new ExtendedButton(this.hatList.x, this.hatList.y - 20, this.hatList.getWidth() + 1, 20, "", b -> this.setHatListVisibility(!this.hatList.visible)));
        this.useLordSkinButton = (CheckboxButton)this.addButton((Widget)new CheckboxButton(this.guiLeft + 20, this.guiTop + 86, 99, 20, UtilLib.translate("gui.vampirism.minion_appearance.use_lord_skin", new Object[0]), this.useLordSkin){

            public void onPress() {
                super.onPress();
                HunterMinionAppearanceScreen.this.useLordSkin = this.func_212942_a();
                ((HunterMinionEntity)HunterMinionAppearanceScreen.this.entity).setUseLordSkin(HunterMinionAppearanceScreen.this.useLordSkin);
            }
        });
        this.setSkinListVisibility(false);
        this.setHatListVisibility(false);
    }

    private void hat(int type) {
        this.hatType = type;
        ((HunterMinionEntity)this.entity).setHatType(this.hatType);
    }

    private void onNameChanged(String newName) {
        ((HunterMinionEntity)this.entity).changeMinionName(newName);
    }

    private void setHatListVisibility(boolean show) {
        this.hatButton.setMessage(this.hatList.getMessage() + " " + (this.hatType + 1));
        this.hatList.visible = show;
        if (show) {
            this.skinList.visible = false;
        }
        this.useLordSkinButton.visible = !show;
    }

    private void setSkinListVisibility(boolean show) {
        this.skinButton.setMessage(this.skinList.getMessage() + " " + (this.skinType + 1));
        this.skinList.visible = show;
        this.hatButton.visible = !show;
        boolean bl = this.useLordSkinButton.visible = !show;
        if (show) {
            this.hatList.visible = false;
        }
    }

    private void skin(int type) {
        this.skinType = type;
        ((HunterMinionEntity)this.entity).setHunterType(this.skinType);
        this.setSkinListVisibility(false);
    }
}

