/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import de.teamlapen.vampirism.client.gui.MinionStatsScreen;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class HunterMinionStatsScreen
extends MinionStatsScreen<HunterMinionEntity.HunterMinionData, HunterMinionEntity> {
    private final TranslationTextComponent inventoryLevel = new TranslationTextComponent("text.vampirism.minion.stats.inventory_level", new Object[0]);
    private final TranslationTextComponent healthLevel = new TranslationTextComponent("attribute.name." + SharedMonsterAttributes.field_111267_a.func_111108_a(), new Object[0]);
    private final TranslationTextComponent strengthLevel = new TranslationTextComponent("attribute.name." + SharedMonsterAttributes.field_111264_e.func_111108_a(), new Object[0]);
    private final TranslationTextComponent resourceLevel = new TranslationTextComponent("text.vampirism.minion.stats.resource_level", new Object[0]);

    public HunterMinionStatsScreen(HunterMinionEntity entity, @Nullable Screen backScreen) {
        super(entity, 4, backScreen);
    }

    @Override
    protected boolean isActive(HunterMinionEntity.HunterMinionData data, int i) {
        switch (i) {
            case 0: {
                return data.getRemainingStatPoints() > 0 && data.getInventoryLevel() < 2;
            }
            case 1: {
                return data.getRemainingStatPoints() > 0 && data.getHealthLevel() < 3;
            }
            case 2: {
                return data.getRemainingStatPoints() > 0 && data.getStrengthLevel() < 3;
            }
            case 3: {
                return data.getRemainingStatPoints() > 0 && data.getResourceEfficiencyLevel() < 2;
            }
        }
        return false;
    }

    @Override
    protected boolean areButtonsVisible(HunterMinionEntity.HunterMinionData d) {
        return d.getRemainingStatPoints() > 0 || d.getLevel() < 6;
    }

    @Override
    protected int getRemainingStatPoints(HunterMinionEntity.HunterMinionData d) {
        return d.getRemainingStatPoints();
    }

    @Override
    protected void renderStats(HunterMinionEntity.HunterMinionData data) {
        this.renderLevelRow(data.getLevel() + 1, 7);
        this.renderStatRow(0, this.inventoryLevel, new StringTextComponent("" + data.getInventorySize()), data.getInventoryLevel() + 1, 3);
        this.renderStatRow(1, this.healthLevel, new StringTextComponent("" + ((HunterMinionEntity)this.entity).func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b()), data.getHealthLevel() + 1, 4);
        this.renderStatRow(2, this.strengthLevel, new StringTextComponent("" + ((HunterMinionEntity)this.entity).func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b()), data.getStrengthLevel() + 1, 4);
        this.renderStatRow(3, this.resourceLevel, new StringTextComponent("" + (int)Math.ceil((float)(data.getResourceEfficiencyLevel() + 1) / 3.0f * 100.0f) + "%"), data.getResourceEfficiencyLevel() + 1, 3);
    }
}

