/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import de.teamlapen.lib.lib.client.gui.ScrollableListButton;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.inventory.container.MinionContainer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.gui.widget.button.LockIconButton;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class MinionScreen
extends ContainerScreen<MinionContainer> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("vampirism", "textures/gui/minion_inventory.png");
    private final int extraSlots;
    private ScrollableListButton taskList;
    private Button taskButton;
    private Button appearanceButton;
    private Button statButton;
    private LockIconButton lockActionButton;

    public MinionScreen(MinionContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)Objects.requireNonNull(screenContainer), inv, titleIn);
        this.field_146999_f = 214;
        this.field_147000_g = 185;
        this.extraSlots = screenContainer.getExtraSlots();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        this.minecraft.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.blit(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int k = this.extraSlots; k < 15; ++k) {
            this.blit(i + 29 + 18 * (k / 3), j + 44 + 18 * (k % 3), 236, 80, 13, 13);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.title.func_150254_d(), 5.0f, 6.0f, 0x404040);
        this.font.func_211126_b(UtilLib.translate("gui.vampirism.minion.active_task", new Object[0]), 120.0f, 10.0f, 0x404040);
    }

    protected void init() {
        super.init();
        this.appearanceButton = (Button)this.addButton((Widget)new ImageButton(this.field_147003_i + 6, this.field_147009_r + 21, 18, 18, 238, 0, 18, GUI_TEXTURE, this::onConfigurePressed));
        this.lockActionButton = (LockIconButton)this.addButton((Widget)new LockIconButton(this.field_147003_i + 99, this.field_147009_r + 19, this::toggleActionLock));
        this.statButton = (Button)this.addButton((Widget)new ImageButton(this.field_147003_i + 6, this.field_147009_r + 40, 18, 18, 220, 0, 18, GUI_TEXTURE, this::onStatsPressed));
        this.lockActionButton.func_175229_b(((MinionContainer)this.field_147002_h).isTaskLocked());
        String[] taskNames = (String[])Arrays.stream(((MinionContainer)this.field_147002_h).getAvailableTasks()).map(IMinionTask::getName).map(ITextComponent::func_150254_d).toArray(String[]::new);
        this.taskList = (ScrollableListButton)this.addButton((Widget)new ScrollableListButton(this.field_147003_i + 119, this.field_147009_r + 19 + 19, 87, Math.min(3, taskNames.length), taskNames.length, taskNames, "", this::selectTask, false));
        this.taskList.visible = false;
        this.taskButton = (Button)this.addButton((Widget)new ExtendedButton(this.field_147003_i + 119, this.field_147009_r + 19, 88, 20, this.getActiveTaskName(), button -> {
            this.taskList.visible = !this.taskList.visible;
        }));
    }

    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        this.taskList.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
        return super.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        if (this.lockActionButton.isMouseOver((double)mouseX, (double)mouseY)) {
            this.drawButtonTip(UtilLib.translate("gui.vampirism.minion.lock_action", new Object[0]), mouseX, mouseY);
        } else if (this.appearanceButton.isMouseOver((double)mouseX, (double)mouseY)) {
            this.drawButtonTip(UtilLib.translate("gui.vampirism.minion.appearance", new Object[0]), mouseX, mouseY);
        } else if (this.statButton.isMouseOver((double)mouseX, (double)mouseY)) {
            this.drawButtonTip(UtilLib.translate("gui.vampirism.minion_stats", new Object[0]), mouseX, mouseY);
        } else {
            super.func_191948_b(mouseX, mouseY);
        }
    }

    private void drawButtonTip(String text, int mouseX, int mouseY) {
        GuiUtils.drawHoveringText((ItemStack)ItemStack.field_190927_a, Collections.singletonList(text), (int)mouseX, (int)mouseY, (int)this.minecraft.func_228018_at_().func_198107_o(), (int)this.minecraft.func_228018_at_().func_198087_p(), (int)-1, (FontRenderer)this.font);
    }

    private String getActiveTaskName() {
        return ((MinionContainer)this.field_147002_h).getSelectedTask().getName().func_150254_d();
    }

    private void onConfigurePressed(Button b) {
        ((MinionContainer)this.field_147002_h).openConfigurationScreen();
    }

    private void onStatsPressed(Button b) {
        ((MinionContainer)this.field_147002_h).openStatsScreen();
    }

    private void selectTask(int id) {
        this.taskList.visible = false;
        ((MinionContainer)this.field_147002_h).setTaskToActivate(id);
        this.taskButton.setMessage(this.getActiveTaskName());
    }

    private void toggleActionLock(Button b) {
        this.lockActionButton.func_175229_b(!this.lockActionButton.func_175230_c());
        ((MinionContainer)this.field_147002_h).setTaskLocked(this.lockActionButton.func_175230_c());
    }
}

