/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.network.UpgradeMinionStatPacket;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class MinionStatsScreen<T extends MinionData, Q extends MinionEntity<T>>
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("vampirism", "textures/gui/appearance.png");
    protected final Q entity;
    protected final int xSize = 256;
    protected final int ySize = 177;
    protected final int statCount;
    private final TranslationTextComponent textLevel = new TranslationTextComponent("text.vampirism.level", new Object[0]);
    private final List<Button> statButtons = new ArrayList<Button>();
    protected int guiLeft;
    protected int guiTop;
    @Nullable
    protected final Screen backScreen;

    protected MinionStatsScreen(Q entity, int statCount, @Nullable Screen backScreen) {
        super((ITextComponent)new TranslationTextComponent("gui.vampirism.minion_stats", new Object[0]));
        assert (statCount > 0);
        this.entity = entity;
        this.statCount = statCount;
        this.backScreen = backScreen;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        this.renderGuiBackground();
        this.drawTitle();
        super.render(mouseX, mouseY, partialTicks);
        ((MinionEntity)this.entity).getMinionData().ifPresent(this::renderStats);
    }

    public void tick() {
        for (int i = 0; i < this.statCount; ++i) {
            int finalI = i;
            this.statButtons.get((int)i).active = ((MinionEntity)this.entity).getMinionData().map(d -> this.isActive(d, finalI)).orElse(false);
            this.statButtons.get((int)i).visible = ((MinionEntity)this.entity).getMinionData().map(this::areButtonsVisible).orElse(false);
        }
    }

    protected abstract int getRemainingStatPoints(T var1);

    protected abstract boolean isActive(T var1, int var2);

    protected abstract boolean areButtonsVisible(T var1);

    protected void init() {
        this.statButtons.clear();
        this.guiLeft = (this.width - this.xSize) / 2;
        this.guiTop = (this.height - this.ySize) / 2;
        this.addButton((Widget)new Button(this.guiLeft + this.xSize - 80 - 20, this.guiTop + 152, 80, 20, UtilLib.translate("gui.done", new Object[0]), context -> this.onClose()));
        if (this.backScreen != null) {
            this.addButton((Widget)new Button(this.guiLeft + 20, this.guiTop + 152, 80, 20, UtilLib.translate("gui.back", new Object[0]), context -> Minecraft.func_71410_x().func_147108_a(this.backScreen)));
        }
        for (int i = 0; i < this.statCount; ++i) {
            int finalI = i;
            Button button = (Button)this.addButton((Widget)new Button(this.guiLeft + 225, this.guiTop + 43 + 26 * i, 20, 20, "+", b -> VampirismMod.dispatcher.sendToServer(new UpgradeMinionStatPacket(this.entity.func_145782_y(), finalI))));
            this.statButtons.add(button);
            button.visible = false;
        }
    }

    protected void renderGuiBackground() {
        this.minecraft.func_110434_K().func_110577_a(BACKGROUND);
        MinionStatsScreen.blit((int)this.guiLeft, (int)this.guiTop, (int)this.getBlitOffset(), (float)0.0f, (float)0.0f, (int)this.xSize, (int)this.ySize, (int)256, (int)300);
    }

    protected void renderLevelRow(int current, int max) {
        this.font.func_211126_b(this.textLevel.func_150254_d(), (float)(this.guiLeft + 10), (float)(this.guiTop + 30), 0);
        this.font.func_211126_b(current + "/" + max, (float)(this.guiLeft + 145), (float)(this.guiTop + 30), 0x404040);
        int remainingPoints = ((MinionEntity)this.entity).getMinionData().map(this::getRemainingStatPoints).orElse(0);
        if (remainingPoints > 0) {
            this.font.func_211126_b("(" + remainingPoints + ")", (float)(this.guiLeft + 228), (float)(this.guiTop + 30), 0x404040);
        }
        this.hLine(this.guiLeft + 10, this.guiLeft + 256 - 10, this.guiTop + 40, -265277392);
    }

    protected void renderStatRow(int i, TranslationTextComponent name, StringTextComponent value, int currentLevel, int maxLevel) {
        this.font.func_211126_b(name.func_150254_d() + ":", (float)(this.guiLeft + 10), (float)(this.guiTop + 50 + 26 * i), 0x404040);
        this.font.func_211126_b(value.func_150254_d(), (float)(this.guiLeft + 145), (float)(this.guiTop + 50 + 26 * i), 0x404040);
        this.font.func_211126_b(UtilLib.translate("text.vampirism.level_short", new Object[0]) + ": " + currentLevel + "/" + maxLevel, (float)(this.guiLeft + 175), (float)(this.guiTop + 50 + 26 * i), 0x404040);
    }

    protected void renderStats(T data) {
    }

    private void drawTitle() {
        String title = this.title.func_150254_d();
        this.font.func_175063_a(title, (float)(this.guiLeft + 10), (float)(this.guiTop + 10), 0xFFFFFF);
    }
}

