/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import de.teamlapen.lib.lib.client.gui.ScrollableListButton;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.network.RequestMinionSelectPacket;
import de.teamlapen.vampirism.network.SelectMinionTaskPacket;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class SelectMinionScreen
extends Screen {
    private final Integer[] minionIds;
    private final String[] minionNames;
    private final RequestMinionSelectPacket.Action action;

    public SelectMinionScreen(RequestMinionSelectPacket.Action a, List<Pair<Integer, ITextComponent>> minions) {
        super((ITextComponent)new StringTextComponent(""));
        this.action = a;
        this.minionIds = (Integer[])minions.stream().map(Pair::getLeft).toArray(Integer[]::new);
        this.minionNames = (String[])minions.stream().map(Pair::getRight).map(ITextComponent::func_150254_d).toArray(String[]::new);
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground();
        super.render(p_render_1_, p_render_2_, p_render_3_);
    }

    protected void init() {
        super.init();
        int w = 100;
        int maxH = 5;
        this.addButton((Widget)new ScrollableListButton((this.width - w) / 2, (this.height - maxH * 20) / 2, w, Math.min(5, this.minionNames.length), this.minionNames.length, this.minionNames, "", this::onMinionSelected, false));
    }

    private void onMinionSelected(int id) {
        int selectedMinion = this.minionIds[id];
        if (this.action == RequestMinionSelectPacket.Action.CALL) {
            VampirismMod.dispatcher.sendToServer(new SelectMinionTaskPacket(selectedMinion, SelectMinionTaskPacket.RECALL));
        }
        this.onClose();
    }
}

