/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import de.teamlapen.lib.lib.client.gui.GuiPieMenu;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.minion.IMinionTask;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.client.gui.SelectActionScreen;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.network.InputEventPacket;
import de.teamlapen.vampirism.network.SelectMinionTaskPacket;
import java.awt.Color;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SelectMinionTaskScreen
extends GuiPieMenu<Entry> {
    public SelectMinionTaskScreen() {
        super(Color.gray, (ITextComponent)new TranslationTextComponent("text.vampirism.minion.give_order", new Object[0]));
    }

    @Override
    protected ResourceLocation getIconLoc(Entry item) {
        return item.getIconLoc();
    }

    @Override
    protected KeyBinding getMenuKeyBinding() {
        return ModKeys.getKeyBinding(ModKeys.KEY.MINION);
    }

    public boolean keyPressed(int key, int scancode, int modifiers) {
        IPlayableFaction<IFactionPlayer<?>> faction;
        if (key == 32 && Minecraft.func_71410_x().field_71439_g.func_70089_S() && (faction = FactionPlayerHandler.get((PlayerEntity)Minecraft.func_71410_x().field_71439_g).getCurrentFaction()) != null) {
            Minecraft.func_71410_x().func_147108_a((Screen)new SelectActionScreen(faction.getColor(), false));
        }
        return super.keyPressed(key, scancode, modifiers);
    }

    @Override
    public boolean func_223281_a_(int key, int scancode, int modifiers) {
        if (ModKeys.getKeyBinding(ModKeys.KEY.MINION).func_197976_a(key, scancode) || ModKeys.getKeyBinding(ModKeys.KEY.ACTION).func_197976_a(key, scancode)) {
            this.onClose();
            if (this.getSelectedElement() >= 0) {
                this.onElementSelected((Entry)this.elements.get(this.getSelectedElement()));
            }
        }
        return false;
    }

    @Override
    protected ITextComponent getName(Entry item) {
        return item.getText();
    }

    @Override
    protected void onElementSelected(Entry id) {
        id.onSelected(this);
    }

    @Override
    protected void onGuiInit() {
        this.elements.clear();
        FactionPlayerHandler.getOpt((PlayerEntity)this.minecraft.field_71439_g).ifPresent(fp -> this.elements.addAll(PlayerMinionController.getAvailableTasks(fp).stream().map(Entry::new).collect(Collectors.toList())));
        this.elements.add(new Entry((ITextComponent)new TranslationTextComponent("action.vampirism.cancel", new Object[0]), new ResourceLocation("vampirism", "textures/actions/cancel.png"), GuiPieMenu::onClose));
        this.elements.add(new Entry((ITextComponent)new TranslationTextComponent("text.vampirism.minion.call_single", new Object[0]), new ResourceLocation("vampirism", "textures/minion_tasks/recall_single.png"), SelectMinionTaskScreen::callSingle));
        this.elements.add(new Entry((ITextComponent)new TranslationTextComponent("text.vampirism.minion.call_all", new Object[0]), new ResourceLocation("vampirism", "textures/minion_tasks/recall.png"), SelectMinionTaskScreen::callAll));
        this.elements.add(new Entry((ITextComponent)new TranslationTextComponent("text.vampirism.minion.respawn", new Object[0]), new ResourceLocation("vampirism", "textures/minion_tasks/respawn.png"), SelectMinionTaskScreen::callRespawn));
    }

    private void callAll() {
        VampirismMod.dispatcher.sendToServer(new SelectMinionTaskPacket(-1, SelectMinionTaskPacket.RECALL));
    }

    private void callRespawn() {
        VampirismMod.dispatcher.sendToServer(new SelectMinionTaskPacket(-1, SelectMinionTaskPacket.RESPAWN));
    }

    private void callSingle() {
        VampirismMod.dispatcher.sendToServer(new InputEventPacket("sm", ""));
    }

    private void sendTask(IMinionTask<?, ?> task) {
        VampirismMod.dispatcher.sendToServer(new SelectMinionTaskPacket(-1, task.getRegistryName()));
    }

    public static class Entry {
        private final ITextComponent text;
        private final ResourceLocation loc;
        private final Consumer<SelectMinionTaskScreen> onSelected;

        public Entry(IMinionTask<?, ?> task) {
            this(task.getName(), new ResourceLocation(task.getRegistryName().func_110624_b(), "textures/minion_tasks/" + task.getRegistryName().func_110623_a() + ".png"), screen -> ((SelectMinionTaskScreen)screen).sendTask(task));
        }

        public Entry(ITextComponent text, ResourceLocation icon, Consumer<SelectMinionTaskScreen> onSelected) {
            this.text = text;
            this.loc = icon;
            this.onSelected = onSelected;
        }

        public ResourceLocation getIconLoc() {
            return this.loc;
        }

        public ITextComponent getText() {
            return this.text;
        }

        public void onSelected(SelectMinionTaskScreen screen) {
            this.onSelected.accept(screen);
        }
    }
}

