/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.task.Task;
import de.teamlapen.vampirism.api.entity.player.task.TaskRequirement;
import de.teamlapen.vampirism.api.entity.player.task.TaskReward;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.inventory.container.TaskBoardContainer;
import de.teamlapen.vampirism.player.tasks.req.ItemRequirement;
import de.teamlapen.vampirism.player.tasks.reward.ItemReward;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class TaskBoardScreen
extends ContainerScreen<TaskBoardContainer> {
    private static final ResourceLocation TASKMASTER_GUI_TEXTURE = new ResourceLocation("vampirism", "textures/gui/taskmaster.png");
    private static final ITextComponent SUBMIT = new TranslationTextComponent("gui.vampirism.taskmaster.complete_task", new Object[0]);
    private static final ITextComponent ACCEPT = new TranslationTextComponent("gui.vampirism.taskmaster.accept_task", new Object[0]);
    private static final ITextComponent ABORT = new TranslationTextComponent("gui.vampirism.taskmaster.abort_task", new Object[0]);
    private static final ITextComponent REQUIREMENT = new TranslationTextComponent("gui.vampirism.taskmaster.requirement", new Object[0]).func_211708_a(TextFormatting.UNDERLINE);
    private static final ITextComponent REQUIREMENT_STRIKE = REQUIREMENT.func_150259_f().func_211708_a(TextFormatting.STRIKETHROUGH);
    private static final ITextComponent REWARD = new TranslationTextComponent("gui.vampirism.taskmaster.reward", new Object[0]).func_211708_a(TextFormatting.UNDERLINE);
    private static final ItemStack SKULL_ITEM = new ItemStack((IItemProvider)Blocks.field_196703_eM);
    private static final ItemStack PAPER = new ItemStack((IItemProvider)Items.field_151121_aF);
    private final TaskActionButton[] buttons = new TaskActionButton[7];
    private final Map<Task, List<String>> toolTips = Maps.newHashMap();
    private final String messageKey;
    private final IFactionPlayer<?> factionPlayer;
    private int scrolledTask;
    private int openedTask;
    private final Task dummy = new Task(Task.Variant.UNIQUE, null, null, null, null, false){

        @Override
        @Nonnull
        public TaskReward getReward() {
            return ((TaskBoardContainer)TaskBoardScreen.this.field_147002_h).getTask(TaskBoardScreen.this.openedTask).getReward();
        }

        @Override
        @Nonnull
        public TaskRequirement getRequirement() {
            return ((TaskBoardContainer)TaskBoardScreen.this.field_147002_h).getTask(TaskBoardScreen.this.openedTask).getRequirement();
        }

        @Override
        @Nullable
        public IPlayableFaction<?> getFaction() {
            return ((TaskBoardContainer)TaskBoardScreen.this.field_147002_h).getTask(TaskBoardScreen.this.openedTask).getFaction();
        }

        @Override
        @Nonnull
        public String getTranslationKey() {
            return ((TaskBoardContainer)TaskBoardScreen.this.field_147002_h).getTask(TaskBoardScreen.this.openedTask).getTranslationKey();
        }
    };
    private boolean isOpen;
    private boolean mouseOnScroller;

    public TaskBoardScreen(TaskBoardContainer container, PlayerInventory playerInventory, ITextComponent containerName) {
        super((Container)container, playerInventory, containerName);
        this.field_146999_f = 176;
        this.field_147000_g = 181;
        this.factionPlayer = FactionPlayerHandler.get(playerInventory.field_70458_d).getCurrentFactionPlayer().get();
        this.messageKey = "gui.vampirism.taskmaster.text." + container.getFaction().getID().toString().replace(':', '_');
    }

    protected void init() {
        super.init();
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        int k = j + 16 + 2;
        for (int l = 0; l < 7; ++l) {
            this.buttons[l] = (TaskActionButton)this.addButton((Widget)new TaskActionButton(i + 5 + 132 - 2, k + 3, l, button -> {
                if (button instanceof TaskActionButton) {
                    Task task = ((TaskBoardContainer)this.field_147002_h).getTask(((TaskActionButton)button).getChosenItem() + this.scrolledTask - 1);
                    if (((TaskBoardContainer)this.field_147002_h).canCompleteTask(task)) {
                        ((TaskBoardContainer)this.field_147002_h).completeTask(task);
                    } else if (((TaskBoardContainer)this.field_147002_h).isTaskNotAccepted(task)) {
                        ((TaskBoardContainer)this.field_147002_h).acceptTask(task);
                    } else {
                        ((TaskBoardContainer)this.field_147002_h).abortTask(task);
                    }
                    this.generateTaskToolTip(task, this.toolTips.get((Object)task));
                }
            }));
            k += 21;
        }
    }

    protected void func_146979_b(int p_146979_1_, int p_146979_2_) {
        String s = this.title.func_150254_d();
        this.font.func_211126_b(s, (float)(this.field_146999_f / 2 - this.font.func_78256_a(s) / 2), 5.0f, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        assert (this.minecraft != null);
        this.minecraft.func_110434_K().func_110577_a(TASKMASTER_GUI_TEXTURE);
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        TaskBoardScreen.blit((int)i, (int)j, (int)this.getBlitOffset(), (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)256, (int)256);
    }

    private static ITextComponent getRequirementTypeTitle(TaskRequirement.Type type) {
        ITextComponent title;
        switch (type) {
            case ITEMS: {
                title = new TranslationTextComponent("gui.vampirism.taskmaster.item_req", new Object[0]).func_150258_a(":");
                break;
            }
            case STATS: {
                title = new TranslationTextComponent("gui.vampirism.taskmaster.stat_req", new Object[0]).func_150258_a(":");
                break;
            }
            case ENTITY: {
                title = new TranslationTextComponent("gui.vampirism.taskmaster.entity_req", new Object[0]).func_150258_a(":");
                break;
            }
            case ENTITY_TAG: {
                title = new TranslationTextComponent("gui.vampirism.taskmaster.entity_tag_req", new Object[0]).func_150258_a(":");
                break;
            }
            default: {
                title = new TranslationTextComponent("gui.vampirism.taskmaster.bool_req", new Object[0]).func_150258_a(":");
            }
        }
        return title;
    }

    private void renderTaskToolTip(Task task, int x, int y, int mouseX, int mouseY) {
        if (task == this.dummy) {
            if (mouseX >= x + 3 + 113 - 21 && mouseX < x + 3 + 113 - 21 + 16 && mouseY >= y + 2 && mouseY < y + 2 + 16) {
                TaskReward reward = task.getReward();
                if (reward instanceof ItemReward) {
                    this.renderItemTooltip(((ItemReward)reward).getReward(), mouseX, mouseY, REWARD.func_150254_d(), false, null);
                } else {
                    this.renderItemTooltip(task, mouseX, mouseY);
                }
            }
            List<TaskRequirement.Requirement<?>> requirements = task.getRequirement().getAll();
            for (int i = 0; i < requirements.size(); ++i) {
                if (mouseX < x + 3 + 3 + i * 20 || mouseX >= x + 3 + 16 + 3 + i * 20 || mouseY < y + 2 || mouseY >= y + 2 + 16) continue;
                this.renderRequirementTool(((TaskBoardContainer)this.field_147002_h).getTask(this.openedTask), requirements.get(i), mouseX, mouseY);
            }
        } else {
            List<String> toolTips = this.toolTips.getOrDefault((Object)task, Lists.newArrayList());
            if (toolTips.isEmpty()) {
                this.generateTaskToolTip(task, toolTips);
            }
            this.renderTooltip(toolTips, mouseX, mouseY);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.renderMessage();
        List<Task> tasks = ((TaskBoardContainer)this.field_147002_h).getVisibleTasks();
        if (!tasks.isEmpty()) {
            int i = (this.width - this.field_146999_f) / 2;
            int j = (this.height - this.field_147000_g) / 2;
            int k = j + 16 + 3 + 2;
            RenderSystem.pushMatrix();
            RenderSystem.enableRescaleNormal();
            RenderSystem.enableColorMaterial();
            RenderSystem.enableLighting();
            this.renderScroller(i + 60, j - 1, tasks);
            int i1 = 0;
            for (Task task : tasks) {
                if (tasks.size() <= 7 || i1 >= this.scrolledTask && i1 < 7 + this.scrolledTask) {
                    this.renderTask(task, i - 1 + 17, k - 4);
                    k += 21;
                }
                ++i1;
            }
            for (TaskActionButton button : this.buttons) {
                button.visible = button.getChosenItem() < ((TaskBoardContainer)this.field_147002_h).size() && ((TaskBoardContainer)this.field_147002_h).getTask(button.getChosenItem() + this.scrolledTask) == this.dummy && !((TaskBoardContainer)this.field_147002_h).isCompleted(((TaskBoardContainer)this.field_147002_h).getTask(button.getChosenItem() + this.scrolledTask - 1));
            }
            for (TaskActionButton button : this.buttons) {
                button.render(mouseX, mouseY, partialTicks);
            }
            for (TaskActionButton button : this.buttons) {
                button.renderToolTip(mouseX, mouseY);
            }
            i1 = 0;
            k = j + 16 + 3 + 2;
            for (Task task : tasks) {
                if (tasks.size() <= 7 || i1 >= this.scrolledTask && i1 < 7 + this.scrolledTask) {
                    if (mouseX > i - 1 + 17 && mouseX < i - 1 + 139 + 17 && mouseY > k - 4 && mouseY < k + 21 - 4) {
                        this.renderTaskToolTip(task, i - 1 + 17, k - 4, mouseX, mouseY);
                    }
                    k += 21;
                }
                ++i1;
            }
            RenderSystem.popMatrix();
        }
    }

    private void generateTaskToolTip(Task task, List<String> toolTips) {
        toolTips.clear();
        toolTips.add(task.getTranslation().func_211708_a(((TaskBoardContainer)this.field_147002_h).getFactionColor()).func_150254_d());
        if (task.useDescription()) {
            toolTips.add(task.getDescription().func_150254_d());
            toolTips.add("");
        }
        if (((TaskBoardContainer)this.field_147002_h).isTaskNotAccepted(task)) {
            toolTips.add(new TranslationTextComponent("gui.vampirism.taskmaster.not_accepted", new Object[0]).func_150254_d());
        } else {
            for (List<TaskRequirement.Requirement<?>> requirements : task.getRequirement().requirements().values()) {
                if (requirements == null) continue;
                TaskRequirement.Type type = requirements.get(0).getType();
                boolean completed = ((TaskBoardContainer)this.field_147002_h).areRequirementsCompleted(task, type);
                ITextComponent title = TaskBoardScreen.getRequirementTypeTitle(type);
                if (completed) {
                    title.func_211708_a(TextFormatting.STRIKETHROUGH);
                }
                toolTips.add(title.func_150254_d());
                for (TaskRequirement.Requirement<?> requirement : requirements) {
                    TranslationTextComponent desc;
                    int completedAmount = ((TaskBoardContainer)this.field_147002_h).getRequirementStatus(task, requirement);
                    switch (type) {
                        case ITEMS: {
                            desc = ((Item)requirement.getStat(this.factionPlayer)).func_200296_o().func_150259_f().func_150258_a(" " + completedAmount + "/" + requirement.getAmount(this.factionPlayer));
                            break;
                        }
                        case STATS: {
                            desc = new TranslationTextComponent("stat." + requirement.getStat(this.factionPlayer).toString().replace(':', '.'), new Object[0]).func_150258_a(" " + completedAmount + "/" + requirement.getAmount(this.factionPlayer));
                            break;
                        }
                        case ENTITY: {
                            desc = ((EntityType)requirement.getStat(this.factionPlayer)).func_212546_e().func_150259_f().func_150258_a(" " + completedAmount + "/" + requirement.getAmount(this.factionPlayer));
                            break;
                        }
                        case ENTITY_TAG: {
                            desc = new TranslationTextComponent("tasks.vampirism." + ((Tag)requirement.getStat(this.factionPlayer)).func_199886_b().toString(), new Object[0]).func_150258_a(" " + completedAmount + "/" + requirement.getAmount(this.factionPlayer));
                            break;
                        }
                        default: {
                            desc = new TranslationTextComponent(task.getTranslationKey() + ".req." + requirement.getId().toString().replace(':', '.'), new Object[0]);
                        }
                    }
                    if (completed || ((TaskBoardContainer)this.field_147002_h).isRequirementCompleted(task, requirement)) {
                        desc.func_211708_a(TextFormatting.STRIKETHROUGH);
                    }
                    toolTips.add(new StringTextComponent("  ").func_150257_a((ITextComponent)desc).func_150254_d());
                }
            }
        }
        this.toolTips.put(task, toolTips);
    }

    private void renderTask(Task task, int x, int y) {
        int offset;
        RenderHelper.func_74518_a();
        GlStateManager.func_227740_m_();
        assert (this.minecraft != null);
        this.minecraft.func_110434_K().func_110577_a(TASKMASTER_GUI_TEXTURE);
        boolean dummy = task == this.dummy;
        int n = offset = dummy ? 21 : 0;
        if (dummy && this.isOpen) {
            task = ((TaskBoardContainer)this.field_147002_h).getTask(this.openedTask);
        }
        if (((TaskBoardContainer)this.field_147002_h).isCompleted(task)) {
            RenderSystem.color4f((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
        } else if (!dummy) {
            if (((TaskBoardContainer)this.field_147002_h).canCompleteTask(task)) {
                if (task.isUnique()) {
                    RenderSystem.color4f((float)1.0f, (float)0.8558594f, (float)0.0f, (float)1.0f);
                } else {
                    RenderSystem.color4f((float)0.0f, (float)0.9f, (float)0.0f, (float)1.0f);
                }
            } else if (((TaskBoardContainer)this.field_147002_h).isTaskNotAccepted(task)) {
                if (task.isUnique()) {
                    RenderSystem.color4f((float)0.64f, (float)0.57f, (float)0.5f, (float)1.0f);
                } else {
                    RenderSystem.color4f((float)0.55f, (float)0.55f, (float)0.55f, (float)1.0f);
                }
            } else if (task.isUnique()) {
                RenderSystem.color4f((float)1.0f, (float)0.9f, (float)0.6f, (float)1.0f);
            } else {
                RenderSystem.color4f((float)0.85f, (float)1.0f, (float)0.85f, (float)1.0f);
            }
        }
        TaskBoardScreen.blit((int)x, (int)y, (int)this.getBlitOffset(), (float)16.0f, (float)(187 + offset), (int)137, (int)21, (int)256, (int)256);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!dummy) {
            this.font.func_211126_b(this.font.func_78269_a(task.getTranslation().func_150254_d(), 131), (float)(x + 4), (float)(y + 7), 3419941);
        } else {
            TaskReward reward = task.getReward();
            if (reward instanceof ItemReward) {
                ItemStack stack = ((ItemReward)reward).getReward();
                this.itemRenderer.func_180450_b(stack, x + 3 + 113 - 21, y + 2);
                this.itemRenderer.func_180453_a(this.font, stack, x + 3 + 113 - 21, y + 2, "" + Math.min(stack.func_190916_E(), stack.func_77976_d()));
            } else {
                this.itemRenderer.func_180450_b(PAPER, x + 3 + 113 - 21, y + 2);
            }
            List<TaskRequirement.Requirement<?>> requirements = task.getRequirement().getAll();
            block4: for (int i = 0; i < requirements.size(); ++i) {
                TaskRequirement.Requirement<?> requirement = requirements.get(i);
                switch (requirement.getType()) {
                    case ITEMS: {
                        ItemStack stack = ((ItemRequirement)requirement).getItemStack();
                        this.itemRenderer.func_180450_b(stack, x + 3 + 3 + i * 20, y + 2);
                        this.itemRenderer.func_180453_a(this.font, stack, x + 3 + 3 + i * 20, y + 2, "" + Math.min(stack.func_190916_E(), stack.func_77976_d()));
                        continue block4;
                    }
                    case ENTITY: 
                    case ENTITY_TAG: {
                        this.itemRenderer.func_180450_b(SKULL_ITEM, x + 3 + 3 + i * 20, y + 2);
                        this.itemRenderer.func_180453_a(this.font, SKULL_ITEM, x + 3 + 3 + i * 20, y + 2, "" + requirement.getAmount(this.factionPlayer));
                        continue block4;
                    }
                    default: {
                        this.itemRenderer.func_180450_b(PAPER, x + 3 + 3 + i * 20, y + 2);
                    }
                }
            }
        }
    }

    private void renderGenericRequirementTooltip(TaskRequirement.Type type, int x, int y, ITextComponent text, boolean strikeThrough) {
        ArrayList tooltips = Lists.newArrayList();
        ITextComponent title = TaskBoardScreen.getRequirementTypeTitle(type);
        if (strikeThrough) {
            text.func_211708_a(TextFormatting.STRIKETHROUGH);
            title.func_211708_a(TextFormatting.STRIKETHROUGH);
        }
        tooltips.add((strikeThrough ? REQUIREMENT_STRIKE : REQUIREMENT).func_150254_d());
        tooltips.add(title.func_211708_a(TextFormatting.ITALIC).func_150254_d());
        tooltips.add("  " + text.func_150254_d());
        this.renderTooltip(tooltips, x, y, this.font);
    }

    private void renderDefaultRequirementToolTip(Task task, TaskRequirement.Requirement<?> requirement, int x, int y, boolean strikeThrough) {
        ArrayList tooltips = Lists.newArrayList();
        tooltips.add((strikeThrough ? REQUIREMENT_STRIKE : REQUIREMENT).func_150254_d());
        TranslationTextComponent text = new TranslationTextComponent(task.getTranslationKey() + ".req." + requirement.getId().toString().replace(':', '.'), new Object[0]);
        if (strikeThrough) {
            text.func_211708_a(TextFormatting.STRIKETHROUGH);
        }
        tooltips.add(text.func_150254_d());
        this.renderTooltip(tooltips, x, y, this.font);
    }

    private void renderRequirementTool(Task task, TaskRequirement.Requirement<?> requirement, int x, int y) {
        boolean notAccepted = ((TaskBoardContainer)this.field_147002_h).isTaskNotAccepted(task);
        boolean completed = ((TaskBoardContainer)this.field_147002_h).isRequirementCompleted(task, requirement);
        int completedAmount = ((TaskBoardContainer)this.field_147002_h).getRequirementStatus(task, requirement);
        switch (requirement.getType()) {
            case ITEMS: {
                this.renderItemTooltip(((ItemRequirement)requirement).getItemStack(), x, y, (completed ? REQUIREMENT_STRIKE : REQUIREMENT).func_150254_d(), completed, notAccepted ? null : completedAmount + "/");
                break;
            }
            case ENTITY: {
                this.renderGenericRequirementTooltip(TaskRequirement.Type.ENTITY, x, y, ((EntityType)requirement.getStat(this.factionPlayer)).func_212546_e().func_150259_f().func_150258_a((notAccepted ? " " : " " + completedAmount + "/") + requirement.getAmount(this.factionPlayer)), completed);
                break;
            }
            case ENTITY_TAG: {
                this.renderGenericRequirementTooltip(TaskRequirement.Type.ENTITY_TAG, x, y, new TranslationTextComponent("tasks.vampirism." + ((Tag)requirement.getStat(this.factionPlayer)).func_199886_b().toString(), new Object[0]).func_150258_a((notAccepted ? " " : " " + completedAmount + "/") + requirement.getAmount(this.factionPlayer)), completed);
                break;
            }
            case STATS: {
                this.renderGenericRequirementTooltip(TaskRequirement.Type.STATS, x, y, new TranslationTextComponent("stat." + requirement.getStat(this.factionPlayer).toString().replace(':', '.'), new Object[0]).func_150258_a((notAccepted ? " " : " " + completedAmount + "/") + requirement.getAmount(this.factionPlayer)), completed);
                break;
            }
            default: {
                this.renderDefaultRequirementToolTip(task, requirement, x, y, completed);
            }
        }
    }

    private void renderItemTooltip(Task task, int x, int y) {
        ArrayList tooltips = Lists.newArrayList((Object[])new String[]{REWARD.func_150254_d()});
        tooltips.add(UtilLib.translate(task.getTranslationKey() + ".reward", new Object[0]));
        this.renderTooltip(tooltips, x, y, this.font);
    }

    private void renderItemTooltip(ItemStack stack, int x, int y, String text, boolean strikeThrough, @Nullable String bonus) {
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        List<String> tooltips = this.getTooltipFromItem2(stack, strikeThrough, bonus);
        tooltips.add(0, text);
        this.renderTooltip(tooltips, x, y, font == null ? this.font : font);
        GuiUtils.postItemToolTip();
    }

    public List<String> getTooltipFromItem2(ItemStack itemStack, boolean strikeThough, @Nullable String bonus) {
        assert (this.minecraft != null);
        List list = itemStack.func_82840_a((PlayerEntity)this.minecraft.field_71439_g, (ITooltipFlag)(this.minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        ((ITextComponent)list.get(0)).func_150258_a(" " + (bonus != null ? bonus : "") + itemStack.func_190916_E());
        ArrayList list1 = Lists.newArrayList();
        for (ITextComponent itextcomponent : list) {
            if (strikeThough) {
                itextcomponent.func_211708_a(TextFormatting.STRIKETHROUGH);
            }
            list1.add(itextcomponent.func_150254_d());
        }
        return list1;
    }

    private void renderMessage() {
        RenderSystem.disableRescaleNormal();
        RenderHelper.func_74518_a();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        int width = (this.width - this.field_146999_f) / 2 - 20;
        List lines = this.font.func_78271_c(UtilLib.translate(this.messageKey, new Object[0]), width);
        int x = 10;
        int y = (this.height - this.field_147000_g) / 2 + 5;
        int height = 8;
        if (lines.size() > 1) {
            height += 2 + (lines.size() - 1) * 10;
        }
        this.setBlitOffset(300);
        this.itemRenderer.field_77023_b = 300.0f;
        int colorCenter = -267386864;
        this.fillGradient(x - 3, y - 4, x + width + 3, y - 3, colorCenter, colorCenter);
        this.fillGradient(x - 3, y + height + 3, x + width + 3, y + height + 4, colorCenter, colorCenter);
        this.fillGradient(x - 3, y - 3, x + width + 3, y + height + 3, colorCenter, colorCenter);
        this.fillGradient(x - 4, y - 3, x - 3, y + height + 3, colorCenter, colorCenter);
        this.fillGradient(x + width + 3, y - 3, x + width + 4, y + height + 3, colorCenter, colorCenter);
        int colorOuter1 = 0x505000FF;
        int colorOuter2 = 1344798847;
        this.fillGradient(x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, colorOuter1, colorOuter2);
        this.fillGradient(x + width + 2, y - 3 + 1, x + width + 3, y + height + 3 - 1, colorOuter1, colorOuter2);
        this.fillGradient(x - 3, y - 3, x + width + 3, y - 3 + 1, colorOuter1, colorOuter1);
        this.fillGradient(x - 3, y + height + 2, x + width + 3, y + height + 3, colorOuter2, colorOuter2);
        for (String line : lines) {
            this.font.func_175063_a(line, (float)x, (float)y, -1);
            y += 10;
        }
        this.setBlitOffset(0);
        this.itemRenderer.field_77023_b = 0.0f;
        RenderSystem.enableLighting();
        RenderSystem.enableDepthTest();
        RenderHelper.func_227780_a_();
        RenderSystem.enableRescaleNormal();
    }

    private void renderScroller(int x, int y, Collection<Task> tasks) {
        assert (this.minecraft != null);
        this.minecraft.func_110434_K().func_110577_a(TASKMASTER_GUI_TEXTURE);
        RenderHelper.func_74518_a();
        int i = tasks.size() - 7;
        if (i >= 1) {
            int k = 144 - (2 + (i - 1) * 144 / i);
            int i1 = Math.min(120, this.scrolledTask * k);
            if (this.scrolledTask >= i + 4) {
                i1 = 120;
            }
            TaskBoardScreen.blit((int)(x + 94), (int)(y + 18 + i1), (int)this.getBlitOffset(), (float)0.0f, (float)181.0f, (int)6, (int)27, (int)256, (int)256);
        } else {
            TaskBoardScreen.blit((int)(x + 94), (int)(y + 18), (int)this.getBlitOffset(), (float)6.0f, (float)181.0f, (int)6, (int)27, (int)256, (int)256);
        }
    }

    private boolean isTaskListTooLong(int size) {
        return size > 7;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollAmount) {
        int i = ((TaskBoardContainer)this.field_147002_h).size();
        if (this.isTaskListTooLong(i)) {
            int j = i - 7;
            this.scrolledTask = (int)((double)this.scrolledTask - scrollAmount);
            this.scrolledTask = MathHelper.func_76125_a((int)this.scrolledTask, (int)0, (int)j);
        }
        return true;
    }

    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int buttonId, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        int i = ((TaskBoardContainer)this.field_147002_h).size();
        if (this.mouseOnScroller) {
            int j = this.field_147009_r + 18;
            int k = j + 144;
            int l = i - 7;
            float f = ((float)p_mouseDragged_3_ - (float)j - 13.5f) / ((float)(k - j) - 27.0f);
            f = f * (float)l + 0.5f;
            this.scrolledTask = MathHelper.func_76125_a((int)((int)f), (int)0, (int)l);
            return true;
        }
        return super.mouseDragged(p_mouseDragged_1_, p_mouseDragged_3_, buttonId, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int buttonId) {
        this.mouseOnScroller = false;
        int i = (this.width - this.field_146999_f) / 2;
        int j = (this.height - this.field_147000_g) / 2;
        if (this.isTaskListTooLong(((TaskBoardContainer)this.field_147002_h).size()) && mouseX > (double)(i + 154) && mouseX < (double)(i + 160) && mouseY > (double)(j + 17) && mouseY <= (double)(j + 166)) {
            this.mouseOnScroller = true;
        }
        if (mouseX > (double)(i + 17) && mouseX < (double)(i + 136 + 17) && mouseY > (double)(j - 4 + 21) && mouseY < (double)(j + 168 - 4)) {
            int num = (int)(mouseY - (double)(j - 4 + 21)) / 21 + this.scrolledTask;
            if (this.isOpen) {
                if (this.openedTask + 1 != num) {
                    ((TaskBoardContainer)this.field_147002_h).getVisibleTasks().remove(this.openedTask + 1);
                    if (num > this.openedTask) {
                        --num;
                    }
                    if (num < ((TaskBoardContainer)this.field_147002_h).size() && num != this.openedTask) {
                        this.openedTask = num;
                        ((TaskBoardContainer)this.field_147002_h).getVisibleTasks().add(this.openedTask + 1, this.dummy);
                    } else {
                        this.isOpen = false;
                        if (((TaskBoardContainer)this.field_147002_h).size() < this.scrolledTask + 7 && this.scrolledTask != 0) {
                            --this.scrolledTask;
                        }
                    }
                }
            } else if (num < ((TaskBoardContainer)this.field_147002_h).size()) {
                this.isOpen = true;
                this.openedTask = num;
                ((TaskBoardContainer)this.field_147002_h).getVisibleTasks().add(this.openedTask + 1, this.dummy);
            }
        }
        return super.mouseClicked(mouseX, mouseY, buttonId);
    }

    private class TaskActionButton
    extends ImageButton {
        final int chosenItem;

        public TaskActionButton(int xPos, int yPos, int chosenItem, Button.IPressable onPress) {
            super(xPos, yPos, 14, 13, 0, 0, 0, TASKMASTER_GUI_TEXTURE, 0, 0, onPress, "");
            this.chosenItem = chosenItem;
            this.visible = false;
        }

        public int getChosenItem() {
            return this.chosenItem;
        }

        public void renderToolTip(int mouseX, int mouseY) {
            if (this.isHovered && this.visible && ((TaskBoardContainer)TaskBoardScreen.this.field_147002_h).size() > this.chosenItem + TaskBoardScreen.this.scrolledTask) {
                TaskBoardContainer.TaskAction action = this.getAction();
                TaskBoardScreen.this.renderTooltip((action == TaskBoardContainer.TaskAction.ACCEPT ? ACCEPT : (action == TaskBoardContainer.TaskAction.ABORT ? ABORT : SUBMIT)).func_150254_d(), mouseX, mouseY);
            }
        }

        public void renderButton(int mouseX, int mouseY, float p_renderButton_3_) {
            int j;
            TaskBoardContainer.TaskAction action = this.getAction();
            Minecraft minecraft = Minecraft.func_71410_x();
            minecraft.func_110434_K().func_110577_a(TASKMASTER_GUI_TEXTURE);
            GlStateManager.func_227731_j_();
            int i = 0;
            if (this.isHovered()) {
                i += 13;
            }
            switch (action) {
                case ACCEPT: {
                    j = 190;
                    break;
                }
                case COMPLETE: {
                    j = 176;
                    break;
                }
                default: {
                    j = 204;
                }
            }
            TaskActionButton.blit((int)this.x, (int)this.y, (float)j, (float)i, (int)this.width, (int)this.height, (int)256, (int)256);
            GlStateManager.func_227734_k_();
        }

        private TaskBoardContainer.TaskAction getAction() {
            Task task = ((TaskBoardContainer)TaskBoardScreen.this.field_147002_h).getTask(this.chosenItem + TaskBoardScreen.this.scrolledTask - 1);
            if (((TaskBoardContainer)TaskBoardScreen.this.field_147002_h).canCompleteTask(task)) {
                return TaskBoardContainer.TaskAction.COMPLETE;
            }
            if (((TaskBoardContainer)TaskBoardScreen.this.field_147002_h).isTaskNotAccepted(task)) {
                return TaskBoardContainer.TaskAction.ACCEPT;
            }
            return TaskBoardContainer.TaskAction.ABORT;
        }
    }
}

