/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import de.teamlapen.lib.lib.client.gui.ScrollableListButton;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.gui.AppearanceScreen;
import de.teamlapen.vampirism.client.render.entities.VampireMinionRenderer;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.network.AppearancePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class VampireMinionAppearanceScreen
extends AppearanceScreen<VampireMinionEntity> {
    private static final ITextComponent NAME = new TranslationTextComponent("gui.vampirism.minion_appearance", new Object[0]);
    private int skinType;
    private boolean useLordSkin;
    private ScrollableListButton typeList;
    private ExtendedButton typeButton;
    private CheckboxButton lordSkinButton;
    private TextFieldWidget nameWidget;

    public VampireMinionAppearanceScreen(VampireMinionEntity minion, Screen backScreen) {
        super(NAME, minion, backScreen);
    }

    public void onClose() {
        String name = this.nameWidget.func_146179_b();
        if (name.isEmpty()) {
            name = new TranslationTextComponent("text.vampirism.minion", new Object[0]).getString() + ((VampireMinionEntity)this.entity).getMinionId().orElse(0);
        }
        VampirismMod.dispatcher.sendToServer(new AppearancePacket(((VampireMinionEntity)this.entity).func_145782_y(), name, this.skinType, this.useLordSkin ? 1 : 0));
        super.onClose();
    }

    @Override
    protected void init() {
        super.init();
        this.nameWidget = (TextFieldWidget)this.addButton((Widget)new TextFieldWidget(this.font, this.guiLeft + 21, this.guiTop + 29, 98, 12, UtilLib.translate("gui.vampirism.minion_appearance.name", new Object[0])));
        this.nameWidget.func_146180_a(((VampireMinionEntity)this.entity).getMinionData().map(MinionData::getName).orElse("Minion"));
        this.nameWidget.func_146204_h(-1);
        this.nameWidget.func_146193_g(-1);
        this.nameWidget.func_146203_f(15);
        this.nameWidget.func_212954_a(this::onNameChanged);
        this.skinType = ((VampireMinionEntity)this.entity).getVampireType();
        this.useLordSkin = ((VampireMinionEntity)this.entity).shouldRenderLordSkin();
        this.typeList = (ScrollableListButton)this.addButton((Widget)new ScrollableListButton(this.guiLeft + 20, this.guiTop + 43 + 19, 99, 5, ((VampireMinionRenderer)Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)this.entity)).getTextureLength(), null, UtilLib.translate("gui.vampirism.minion_appearance.skin", new Object[0]), this::skin, false));
        this.typeButton = (ExtendedButton)this.addButton((Widget)new ExtendedButton(this.typeList.x, this.typeList.y - 20, this.typeList.getWidth() + 1, 20, "", button1 -> this.setListVisibility(!this.typeList.visible)));
        this.lordSkinButton = (CheckboxButton)this.addButton((Widget)new CheckboxButton(this.guiLeft + 20, this.guiTop + 64, 99, 20, UtilLib.translate("gui.vampirism.minion_appearance.use_lord_skin", new Object[0]), this.useLordSkin){

            public void onPress() {
                super.onPress();
                VampireMinionAppearanceScreen.this.useLordSkin = this.func_212942_a();
                ((VampireMinionEntity)VampireMinionAppearanceScreen.this.entity).setUseLordSkin(VampireMinionAppearanceScreen.this.useLordSkin);
            }
        });
        this.setListVisibility(false);
    }

    private void onNameChanged(String newName) {
        ((VampireMinionEntity)this.entity).changeMinionName(newName);
    }

    private void setListVisibility(boolean show) {
        this.typeButton.setMessage(this.typeList.getMessage() + " " + (this.skinType + 1));
        this.typeList.visible = show;
        this.lordSkinButton.visible = !show;
    }

    private void skin(int type) {
        this.skinType = type;
        ((VampireMinionEntity)this.entity).setVampireType(this.skinType);
        this.setListVisibility(false);
    }
}

