/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import de.teamlapen.lib.lib.client.gui.ScrollableListButton;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.client.gui.AppearanceScreen;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.network.AppearancePacket;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.CheckboxButton;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class VampirePlayerAppearanceScreen
extends AppearanceScreen<PlayerEntity> {
    private static final ITextComponent NAME = new TranslationTextComponent("gui.vampirism.appearance", new Object[0]);
    private float[] color;
    private int fangType;
    private int eyeType;
    private boolean glowingEyes;
    private ScrollableListButton eyeList;
    private ScrollableListButton fangList;
    private ExtendedButton eyeButton;
    private ExtendedButton fangButton;
    private CheckboxButton glowingEyesButton;

    public VampirePlayerAppearanceScreen(Screen backScreen) {
        super(NAME, Minecraft.func_71410_x().field_71439_g, backScreen);
    }

    public void onClose() {
        VampirismMod.dispatcher.sendToServer(new AppearancePacket(((PlayerEntity)this.entity).func_145782_y(), "", this.fangType, this.eyeType, this.glowingEyes ? 1 : 0));
        super.onClose();
    }

    @Override
    protected void init() {
        super.init();
        this.color = ((Color)FactionPlayerHandler.getOpt((PlayerEntity)Minecraft.func_71410_x().field_71439_g).map(FactionPlayerHandler::getCurrentFaction).map(IFaction::getColor).orElse((Object)Color.gray)).getRGBColorComponents(null);
        this.fangType = (Integer)VampirePlayer.getOpt((PlayerEntity)this.minecraft.field_71439_g).map(VampirePlayer::getFangType).orElse((Object)0);
        this.eyeType = (Integer)VampirePlayer.getOpt((PlayerEntity)this.minecraft.field_71439_g).map(VampirePlayer::getEyeType).orElse((Object)0);
        this.glowingEyes = (Boolean)VampirePlayer.getOpt((PlayerEntity)this.minecraft.field_71439_g).map(VampirePlayer::getGlowingEyes).orElse((Object)false);
        this.eyeList = (ScrollableListButton)this.addButton((Widget)new ScrollableListButton(this.guiLeft + 20, this.guiTop + 30 + 19, 99, 5, 16, null, UtilLib.translate("gui.vampirism.appearance.eye", new Object[0]), this::eye, false));
        this.fangList = (ScrollableListButton)this.addButton((Widget)new ScrollableListButton(this.guiLeft + 20, this.guiTop + 50 + 19, 99, 4, 7, null, UtilLib.translate("gui.vampirism.appearance.fang", new Object[0]), this::fang, false));
        this.eyeButton = (ExtendedButton)this.addButton((Widget)new ExtendedButton(this.eyeList.x, this.eyeList.y - 20, this.eyeList.getWidth() + 1, 20, "", b -> this.setEyeListVisibility(!this.eyeList.visible)));
        this.fangButton = (ExtendedButton)this.addButton((Widget)new ExtendedButton(this.fangList.x, this.fangList.y - 20, this.fangList.getWidth() + 1, 20, "", b -> this.setFangListVisibility(!this.fangList.visible)));
        this.glowingEyesButton = (CheckboxButton)this.addButton((Widget)new CheckboxButton(this.guiLeft + 20, this.guiTop + 70, 99, 20, UtilLib.translate("gui.vampirism.appearance.glowing_eye", new Object[0]), this.glowingEyes){

            public void onPress() {
                super.onPress();
                VampirePlayerAppearanceScreen.this.glowingEyes = this.func_212942_a();
                VampirePlayer.getOpt((PlayerEntity)VampirePlayerAppearanceScreen.this.entity).ifPresent(p -> p.setGlowingEyes(VampirePlayerAppearanceScreen.this.glowingEyes));
            }
        });
        this.setEyeListVisibility(false);
        this.setFangListVisibility(false);
    }

    @Override
    protected void renderGuiBackground() {
        GlStateManager.func_227702_d_((float)this.color[0], (float)this.color[1], (float)this.color[2], (float)1.0f);
        super.renderGuiBackground();
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void eye(int eyeType) {
        VampirePlayer.getOpt((PlayerEntity)this.minecraft.field_71439_g).ifPresent(vampire -> {
            this.eyeType = eyeType;
            vampire.setEyeType(this.eyeType);
            this.setEyeListVisibility(false);
        });
    }

    private void fang(int fangType) {
        VampirePlayer.getOpt((PlayerEntity)this.minecraft.field_71439_g).ifPresent(vampire -> {
            this.fangType = fangType;
            vampire.setFangType(this.fangType);
            this.setFangListVisibility(false);
        });
    }

    private void setEyeListVisibility(boolean show) {
        this.eyeButton.setMessage(this.eyeList.getMessage() + " " + (this.eyeType + 1));
        this.eyeList.visible = show;
        this.fangButton.visible = !show;
        boolean bl = this.glowingEyesButton.visible = !show;
        if (show) {
            this.fangList.visible = false;
        }
    }

    private void setFangListVisibility(boolean show) {
        this.fangButton.setMessage(this.fangList.getMessage() + " " + (this.fangType + 1));
        this.fangList.visible = show;
        boolean bl = this.glowingEyesButton.visible = !show;
        if (show) {
            this.eyeList.visible = false;
        }
    }
}

