/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.entities;

import de.teamlapen.vampirism.client.model.BasicHunterModel;
import de.teamlapen.vampirism.client.render.entities.HunterEquipmentModel;
import de.teamlapen.vampirism.client.render.layers.CloakLayer;
import de.teamlapen.vampirism.client.render.layers.HunterEquipmentLayer;
import de.teamlapen.vampirism.entity.hunter.BasicHunterEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BasicHunterRenderer
extends BipedRenderer<BasicHunterEntity, BasicHunterModel<BasicHunterEntity>> {
    private final ResourceLocation texture = new ResourceLocation("vampirism", "textures/entity/hunter_base1.png");
    private final ResourceLocation[] textures;
    private final ResourceLocation textureCloak = new ResourceLocation("vampirism", "textures/entity/hunter_cloak.png");

    public BasicHunterRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new BasicHunterModel(), 0.5f);
        this.func_177094_a(new HunterEquipmentLayer(this, entity -> entity.getLevel() < 2 || entity.isCrossbowInMainhand() ? HunterEquipmentModel.StakeType.ONLY : HunterEquipmentModel.StakeType.FULL, entity -> entity.getLevel() == 0 ? entity.getEntityTextureType() % 4 : -1));
        this.func_177094_a(new CloakLayer(this, this.textureCloak, entity -> entity.getLevel() > 0));
        this.textures = (ResourceLocation[])Minecraft.func_71410_x().func_195551_G().func_199003_a("textures/entity/hunter", s -> s.endsWith(".png")).stream().filter(r -> "vampirism".equals(r.func_110624_b())).toArray(ResourceLocation[]::new);
    }

    public ResourceLocation getEntityTexture(BasicHunterEntity entity) {
        int level = entity.getLevel();
        if (level > 0) {
            return this.texture;
        }
        return this.textures[entity.getEntityTextureType() % this.textures.length];
    }
}

