/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.teamlapen.vampirism.client.model.MinionModel;
import de.teamlapen.vampirism.client.render.entities.HunterEquipmentModel;
import de.teamlapen.vampirism.client.render.layers.HunterEquipmentLayer;
import de.teamlapen.vampirism.client.render.layers.PlayerBodyOverlayLayer;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HunterMinionRenderer
extends BipedRenderer<HunterMinionEntity, MinionModel<HunterMinionEntity>> {
    private final ResourceLocation[] textures = (ResourceLocation[])Minecraft.func_71410_x().func_195551_G().func_199003_a("textures/entity/hunter", s -> s.endsWith(".png")).stream().filter(r -> "vampirism".equals(r.func_110624_b())).toArray(ResourceLocation[]::new);

    public HunterMinionRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new MinionModel(0.5f), 0.5f);
        this.func_177094_a(new PlayerBodyOverlayLayer(this));
        this.func_177094_a(new HunterEquipmentLayer(this, hunterMinionEntity -> hunterMinionEntity.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() ? HunterEquipmentModel.StakeType.FULL : HunterEquipmentModel.StakeType.NONE, HunterMinionEntity::getHatType));
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
    }

    protected void preRenderCallback(HunterMinionEntity entityIn, MatrixStack matrixStackIn, float partialTickTime) {
        float s = entityIn.getScale();
        matrixStackIn.func_227862_a_(s, s, s);
    }

    public void render(HunterMinionEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        ((MinionModel)this.field_77045_g).field_187076_m = entityIn.isSwingingArms() ? BipedModel.ArmPose.CROSSBOW_HOLD : BipedModel.ArmPose.ITEM;
        super.func_225623_a_((MobEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    public ResourceLocation getEntityTexture(HunterMinionEntity entity) {
        return this.textures[entity.getHunterType() % this.textures.length];
    }

    public int getTextureLength() {
        return this.textures.length;
    }
}

