/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism.VampirismMod;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;

public class ChangelogCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"changelog").requires(context -> context.func_197034_c(0))).executes(context -> ChangelogCommand.changelog((CommandContext<CommandSource>)context));
    }

    private static int changelog(CommandContext<CommandSource> context) {
        if (!VampirismMod.instance.getVersionInfo().isNewVersionAvailable()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.changelog.newversion", new Object[0]), false);
            return 0;
        }
        VersionChecker.Version newVersion = VampirismMod.instance.getVersionInfo().getNewVersion();
        List<String> changes = newVersion.getChanges();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Vampirism " + newVersion.name + "(" + SharedConstants.func_215069_a().getName() + ")"), true);
        for (String c : changes) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("-" + c), false);
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(""), false);
        String homepage = VampirismMod.instance.getVersionInfo().getHomePage();
        ITextComponent download = new TranslationTextComponent("text.vampirism.update_message.download", new Object[0]).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, newVersion.getUrl() == null ? homepage : newVersion.getUrl())).func_150228_d(Boolean.valueOf(true)).func_150238_a(TextFormatting.BLUE));
        ITextComponent changelog = new TranslationTextComponent("text.vampirism.update_message.changelog", new Object[0]).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/vampirism changelog")).func_150228_d(Boolean.valueOf(true)));
        ITextComponent modpage = new TranslationTextComponent("text.vampirism.update_message.modpage", new Object[0]).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, homepage)).func_150228_d(Boolean.valueOf(true)).func_150238_a(TextFormatting.BLUE));
        ((CommandSource)context.getSource()).func_197030_a(download.func_150258_a(" ").func_150257_a(changelog).func_150258_a(" ").func_150257_a(modpage), false);
        return 1;
    }
}

