/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModBiomes;
import java.util.ArrayList;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.biome.Biome;

public class CheckForVampireBiomeCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"checkForVampireBiome").requires(context -> context.func_197034_c(3))).executes(context -> CheckForVampireBiomeCommand.checkForVampireBiome((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), 500, false))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"maxRadius in chunks", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> CheckForVampireBiomeCommand.checkForVampireBiome((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)context, (String)"maxRadius in chunks"), false))).then(Commands.func_197057_a((String)"!yes").executes(context -> CheckForVampireBiomeCommand.checkForVampireBiome((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), IntegerArgumentType.getInteger((CommandContext)context, (String)"maxRadius in chunks"), true))));
    }

    private static int checkForVampireBiome(CommandContext<CommandSource> context, ServerPlayerEntity entityPlayerMP, int radius, boolean force) {
        if (((Boolean)VampirismConfig.SERVER.disableVampireForestBiomes.get()).booleanValue()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("The Vampire Biome is disabled in the config file", new Object[0]), false);
            return 0;
        }
        if (radius > 500 && !force) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.vampire_biome.time_warning", new Object[]{"checkForVampireBiome", radius}), false);
        } else {
            ArrayList<Biome> biomes = new ArrayList<Biome>();
            biomes.add(ModBiomes.vampire_forest);
            biomes.add(ModBiomes.vampire_forest_hills);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.vampire_biome.searching", new Object[0]), true);
            ChunkPos pos = UtilLib.findNearBiome(entityPlayerMP.func_71121_q(), entityPlayerMP.func_180425_c(), radius, biomes);
            if (pos == null) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.vampire_biome.not_found", new Object[0]), true);
            } else {
                int i = MathHelper.func_76141_d((float)CheckForVampireBiomeCommand.getDistance(((CommandSource)context.getSource()).func_197036_d().func_82615_a(), ((CommandSource)context.getSource()).func_197036_d().func_82616_c(), pos.func_206849_h().func_177958_n(), pos.func_206849_h().func_177952_p()));
                ITextComponent itextcomponent = TextComponentUtils.func_197676_a((ITextComponent)new TranslationTextComponent("chat.coordinates", new Object[]{pos.func_206849_h().func_177958_n(), "~", pos.func_206849_h().func_177952_p()})).func_211710_a(p_211746_1_ -> p_211746_1_.func_150238_a(TextFormatting.GREEN).func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.func_206849_h().func_177958_n() + " ~ " + pos.func_206849_h().func_177952_p())).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TranslationTextComponent("chat.coordinates.tooltip", new Object[0]))));
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.vampire_biome.found", new Object[]{itextcomponent, i}), false);
            }
        }
        return 0;
    }

    private static float getDistance(double x1, double z1, double x2, double z2) {
        double i = x2 - x1;
        double j = z2 - z1;
        return MathHelper.func_76129_c((float)((float)(i * i + j * j)));
    }
}

