/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.command.arguments.FactionArgument;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class LevelCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"level").requires(context -> context.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"faction", (ArgumentType)new FactionArgument()).executes(context -> LevelCommand.setLevel((CommandContext<CommandSource>)context, FactionArgument.getFaction((CommandContext<CommandSource>)context, "faction"), 1, Lists.newArrayList((Object[])new ServerPlayerEntity[]{((CommandSource)context.getSource()).func_197035_h()})))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> LevelCommand.setLevel((CommandContext<CommandSource>)context, FactionArgument.getFaction((CommandContext<CommandSource>)context, "faction"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), Lists.newArrayList((Object[])new ServerPlayerEntity[]{((CommandSource)context.getSource()).func_197035_h()})))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> LevelCommand.setLevel((CommandContext<CommandSource>)context, FactionArgument.getFaction((CommandContext<CommandSource>)context, "faction"), IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), EntityArgument.func_197090_e((CommandContext)context, (String)"player"))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"none").executes(context -> LevelCommand.leaveFaction(Lists.newArrayList((Object[])new ServerPlayerEntity[]{((CommandSource)context.getSource()).func_197035_h()})))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> LevelCommand.leaveFaction(EntityArgument.func_197090_e((CommandContext)context, (String)"player")))));
    }

    private static int setLevel(CommandContext<CommandSource> context, IPlayableFaction<IFactionPlayer<?>> faction, int level, Collection<ServerPlayerEntity> players) {
        for (ServerPlayerEntity player : players) {
            FactionPlayerHandler handler = FactionPlayerHandler.get((PlayerEntity)player);
            if (level == 0 && !handler.canLeaveFaction()) {
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.level.cant_leave", new Object[]{players.size() > 1 ? player.func_145748_c_() : "Player", handler.getCurrentFaction().getName()}));
                continue;
            }
            if (handler.setFactionAndLevel(faction, level = Math.min(level, faction.getHighestReachableLevel()))) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.level.successful", new Object[]{player.func_200200_C_(), faction.getName(), level}), true);
                continue;
            }
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)(players.size() > 1 ? new TranslationTextComponent("command.vampirism.failed_to_execute.players", new Object[]{player.func_145748_c_()}) : new TranslationTextComponent("command.vampirism.failed_to_execute", new Object[0])));
        }
        return 0;
    }

    private static int leaveFaction(Collection<ServerPlayerEntity> players) {
        for (ServerPlayerEntity player : players) {
            FactionPlayerHandler handler = FactionPlayerHandler.get((PlayerEntity)player);
            handler.setFactionAndLevel(null, 0);
        }
        return 0;
    }
}

