/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class LevelUpCommand
extends BasicCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"levelup").requires(context -> context.func_197034_c(2))).executes(context -> LevelUpCommand.levelUp((CommandContext<CommandSource>)context, Lists.newArrayList((Object[])new ServerPlayerEntity[]{((CommandSource)context.getSource()).func_197035_h()})))).then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> LevelUpCommand.levelUp((CommandContext<CommandSource>)context, EntityArgument.func_197090_e((CommandContext)context, (String)"player"))));
    }

    private static int levelUp(CommandContext<CommandSource> context, Collection<ServerPlayerEntity> players) {
        for (ServerPlayerEntity player : players) {
            FactionPlayerHandler handler = FactionPlayerHandler.get((PlayerEntity)player);
            if (handler.getCurrentLevel() == 0) {
                ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.levelup.nofaction", new Object[]{players.size() > 1 ? player.func_145748_c_() : "Player"}));
                continue;
            }
            if (handler.getCurrentLevel() == handler.getCurrentFaction().getHighestReachableLevel()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.levelup.max", new Object[]{players.size() > 1 ? player.func_145748_c_() : "Player"}), true);
                continue;
            }
            if (handler.setFactionAndLevel(handler.getCurrentFaction(), handler.getCurrentLevel() + 1)) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.levelup.newlevel", new Object[]{player.func_200200_C_(), handler.getCurrentFaction().getName(), handler.getCurrentLevel()}), true);
                continue;
            }
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)(players.size() > 1 ? new TranslationTextComponent("command.vampirism.failed_to_execute.players", new Object[]{player.func_145748_c_()}) : new TranslationTextComponent("command.vampirism.failed_to_execute", new Object[0])));
        }
        return 0;
    }
}

