/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.command.test;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.core.ModEntities;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.minion.HunterMinionEntity;
import de.teamlapen.vampirism.entity.minion.MinionEntity;
import de.teamlapen.vampirism.entity.minion.VampireMinionEntity;
import de.teamlapen.vampirism.entity.minion.management.MinionData;
import de.teamlapen.vampirism.entity.minion.management.PlayerMinionController;
import de.teamlapen.vampirism.world.MinionWorldData;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class MinionCommand
extends BasicCommand {
    private static final DynamicCommandExceptionType fail = new DynamicCommandExceptionType(msg -> new StringTextComponent("Failed: " + msg));

    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"minion").requires(context -> context.func_197034_c(2))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"spawnNew").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"vampire").executes(context -> MinionCommand.spawnNewVampireMinion((CommandSource)context.getSource(), "Minion", -1, false))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> MinionCommand.spawnNewVampireMinion((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), -1, false))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"type", (ArgumentType)IntegerArgumentType.integer((int)-1, (int)126)).executes(context -> MinionCommand.spawnNewVampireMinion((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"type"), false))).then(Commands.func_197056_a((String)"use_lord_skin", (ArgumentType)BoolArgumentType.bool()).executes(context -> MinionCommand.spawnNewVampireMinion((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"type"), BoolArgumentType.getBool((CommandContext)context, (String)"use_lord_skin")))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"hunter").executes(context -> MinionCommand.spawnNewHunterMinion((CommandSource)context.getSource(), "Minion", -1, 0, false))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string()).executes(context -> MinionCommand.spawnNewHunterMinion((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), -1, 0, false))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"type", (ArgumentType)IntegerArgumentType.integer((int)-1, (int)126)).executes(context -> MinionCommand.spawnNewHunterMinion((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"type"), 0, false))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"hat", (ArgumentType)IntegerArgumentType.integer((int)-1, (int)3)).executes(context -> MinionCommand.spawnNewHunterMinion((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"type"), IntegerArgumentType.getInteger((CommandContext)context, (String)"hat"), false))).then(Commands.func_197056_a((String)"use_lord_skin", (ArgumentType)BoolArgumentType.bool()).executes(context -> MinionCommand.spawnNewHunterMinion((CommandSource)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"name"), IntegerArgumentType.getInteger((CommandContext)context, (String)"type"), IntegerArgumentType.getInteger((CommandContext)context, (String)"hat"), BoolArgumentType.getBool((CommandContext)context, (String)"use_lord_skin")))))))))).then(Commands.func_197057_a((String)"recall").executes(context -> MinionCommand.recall((CommandSource)context.getSource())))).then(Commands.func_197057_a((String)"respawnAll").executes(context -> MinionCommand.respawn((CommandSource)context.getSource())))).then(Commands.func_197057_a((String)"purge").executes(context -> MinionCommand.purge((CommandSource)context.getSource())))).executes(context -> 0);
    }

    private static int spawnNewVampireMinion(CommandSource ctx, String name, int type, boolean useLordSkin) throws CommandSyntaxException {
        VampireMinionEntity.VampireMinionData data = new VampireMinionEntity.VampireMinionData(name, type, useLordSkin);
        return MinionCommand.spawnNewMinion(ctx, VReference.VAMPIRE_FACTION, data, ModEntities.vampire_minion);
    }

    private static int spawnNewHunterMinion(CommandSource ctx, String name, int type, int hat, boolean useLordSkin) throws CommandSyntaxException {
        HunterMinionEntity.HunterMinionData data = new HunterMinionEntity.HunterMinionData(name, type, hat, useLordSkin);
        return MinionCommand.spawnNewMinion(ctx, VReference.HUNTER_FACTION, data, ModEntities.hunter_minion);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T extends MinionData> int spawnNewMinion(CommandSource ctx, IPlayableFaction<?> faction, T data, EntityType<? extends MinionEntity<T>> type) throws CommandSyntaxException {
        ServerPlayerEntity p = ctx.func_197035_h();
        FactionPlayerHandler fph = FactionPlayerHandler.get((PlayerEntity)p);
        if (fph.getMaxMinions() <= 0) throw fail.create((Object)"Can't have minions");
        PlayerMinionController controller = MinionWorldData.getData(ctx.func_197028_i()).getOrCreateController(fph);
        if (!controller.hasFreeMinionSlot()) throw fail.create((Object)"No free slot");
        if (fph.getCurrentFaction() != faction) throw fail.create((Object)"Wrong faction");
        int id = controller.createNewMinionSlot(data, type);
        if (id < 0) {
            throw fail.create((Object)"Failed to get new minion slot");
        }
        controller.createMinionEntityAtPlayer(id, (PlayerEntity)p);
        return 0;
    }

    private static int recall(CommandSource ctx) throws CommandSyntaxException {
        ServerPlayerEntity p = ctx.func_197035_h();
        FactionPlayerHandler fph = FactionPlayerHandler.get((PlayerEntity)p);
        if (fph.getMaxMinions() > 0) {
            PlayerMinionController controller = MinionWorldData.getData(ctx.func_197028_i()).getOrCreateController(fph);
            Collection<Integer> ids = controller.recallMinions(true);
            for (Integer id : ids) {
                controller.createMinionEntityAtPlayer(id, (PlayerEntity)p);
            }
        } else {
            throw fail.create((Object)"Can't have minions");
        }
        return 0;
    }

    private static int respawn(CommandSource ctx) throws CommandSyntaxException {
        ServerPlayerEntity p = ctx.func_197035_h();
        FactionPlayerHandler fph = FactionPlayerHandler.get((PlayerEntity)p);
        if (fph.getMaxMinions() > 0) {
            PlayerMinionController controller = MinionWorldData.getData(ctx.func_197028_i()).getOrCreateController(fph);
            Collection<Integer> ids = controller.getUnclaimedMinions();
            for (Integer id : ids) {
                controller.createMinionEntityAtPlayer(id, (PlayerEntity)p);
            }
        } else {
            throw fail.create((Object)"Can't have minions");
        }
        return 0;
    }

    private static int purge(CommandSource ctx) throws CommandSyntaxException {
        ServerPlayerEntity p = ctx.func_197035_h();
        MinionWorldData.getData(ctx.func_197028_i()).purgeController(p.func_110124_au());
        p.func_146105_b((ITextComponent)new StringTextComponent("Reload world"), false);
        return 0;
    }
}

