/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.data.recipebuilder.FinishedSkillNode;
import de.teamlapen.vampirism.data.recipebuilder.SkillNodeBuilder;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.player.vampire.skills.VampireSkills;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SkillNodeGenerator
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;

    public SkillNodeGenerator(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        this.registerSkillNodes(node -> {
            if (!set.add(node.getID())) {
                throw new IllegalStateException("Dublicate skill node " + node.getID());
            }
            this.saveSkillNode(cache, node.getSkillNodeJson(), path.resolve("data/" + node.getID().func_110624_b() + "/vampirismskillnodes/" + node.getID().func_110623_a() + ".json"));
        });
    }

    private void saveSkillNode(DirectoryCache cache, JsonObject nodeJson, Path path) {
        try {
            String s = GSON.toJson((JsonElement)nodeJson);
            String s1 = field_208307_a.hashUnencodedChars((CharSequence)s).toString();
            if (!Objects.equals(cache.func_208323_a(path), s1) || !Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    bufferedWriter.write(s);
                }
            }
            cache.func_208316_a(path, s1);
        }
        catch (IOException ioExeption) {
            LOGGER.error("Couldn't save skill node {}", (Object)path, (Object)ioExeption);
        }
    }

    public String func_200397_b() {
        return "Vampirism skillnode generator";
    }

    protected void registerSkillNodes(Consumer<FinishedSkillNode> consumer) {
        ResourceLocation skill2 = SkillNodeBuilder.hunter(this.modId("hunter"), HunterSkills.stake1).build(consumer, this.modId("skill2"));
        ResourceLocation skill3 = SkillNodeBuilder.hunter(skill2, HunterSkills.hunter_attack_speed).build(consumer, this.modId("skill3"));
        ResourceLocation skill4 = SkillNodeBuilder.hunter(skill3, HunterSkills.weapon_table).build(consumer, this.modId("skill4"));
        ResourceLocation alchemy1 = SkillNodeBuilder.hunter(skill4, HunterSkills.basic_alchemy).build(consumer, this.modId("alchemy1"));
        ResourceLocation alchemy2 = SkillNodeBuilder.hunter(alchemy1, HunterSkills.garlic_beacon).build(consumer, this.modId("alchemy2"));
        ResourceLocation alchemy3 = SkillNodeBuilder.hunter(alchemy2, HunterSkills.garlic_beacon).build(consumer, this.modId("alchemy3"));
        ResourceLocation alchemy4 = SkillNodeBuilder.hunter(alchemy3, HunterSkills.purified_garlic, HunterSkills.holy_water_enhanced).build(consumer, this.modId("alchemy4"));
        ResourceLocation alchemy5 = SkillNodeBuilder.hunter(alchemy4, HunterSkills.garlic_beacon_improved).build(consumer, this.modId("alchemy5"));
        ResourceLocation alchemy6 = SkillNodeBuilder.hunter(alchemy5, HunterSkills.hunter_awareness).build(consumer, this.modId("alchemy6"));
        ResourceLocation potion1 = SkillNodeBuilder.hunter(skill4, HunterSkills.multitask_brewing).build(consumer, this.modId("potion1"));
        ResourceLocation potion2 = SkillNodeBuilder.hunter(potion1, HunterSkills.durable_brewing, HunterSkills.concentrated_brewing).build(consumer, this.modId("potion2"));
        ResourceLocation potion3 = SkillNodeBuilder.hunter(potion2, HunterSkills.swift_brewing, HunterSkills.efficient_brewing).build(consumer, this.modId("potion3"));
        ResourceLocation potion4 = SkillNodeBuilder.hunter(potion3, HunterSkills.master_brewer).build(consumer, this.modId("potion4"));
        ResourceLocation potion5 = SkillNodeBuilder.hunter(potion4, HunterSkills.potion_resistance).build(consumer, this.modId("potion5"));
        ResourceLocation potion6 = SkillNodeBuilder.hunter(potion5, HunterSkills.concentrated_durable_brewing).build(consumer, this.modId("potion6"));
        ResourceLocation weapon1 = SkillNodeBuilder.hunter(skill4, HunterSkills.hunter_disguise).build(consumer, this.modId("weapon1"));
        ResourceLocation weapon2 = SkillNodeBuilder.hunter(weapon1, HunterSkills.hunter_attack_speed_advanced, HunterSkills.double_crossbow).build(consumer, this.modId("weapon2"));
        ResourceLocation weapon3 = SkillNodeBuilder.hunter(weapon2, HunterSkills.enhanced_weapons, HunterSkills.enhanced_crossbow).build(consumer, this.modId("weapon3"));
        ResourceLocation weapon4 = SkillNodeBuilder.hunter(weapon3, HunterSkills.enhanced_armor).build(consumer, this.modId("weapon4"));
        ResourceLocation weapon5 = SkillNodeBuilder.hunter(weapon4, HunterSkills.tech_weapons).build(consumer, this.modId("weapon5"));
        ResourceLocation resourceLocation = SkillNodeBuilder.hunter(weapon5, HunterSkills.stake2).build(consumer, this.modId("weapon6"));
        skill2 = SkillNodeBuilder.vampire(this.modId("vampire"), VampireSkills.night_vision).build(consumer, this.modId("skill2"));
        skill3 = SkillNodeBuilder.vampire(skill2, VampireSkills.vampire_regeneration).build(consumer, this.modId("skill3"));
        skill4 = SkillNodeBuilder.vampire(skill3, VampireSkills.bat).build(consumer, this.modId("skill4"));
        ResourceLocation util1 = SkillNodeBuilder.vampire(skill4, VampireSkills.summon_bats).build(consumer, this.modId("util1"));
        ResourceLocation util2 = SkillNodeBuilder.vampire(util1, VampireSkills.less_sundamage, VampireSkills.water_resistance).build(consumer, this.modId("util2"));
        ResourceLocation util3 = SkillNodeBuilder.vampire(util2, VampireSkills.less_blood_thirst).build(consumer, this.modId("util3"));
        ResourceLocation util4 = SkillNodeBuilder.vampire(util3, VampireSkills.vampire_disguise).build(consumer, this.modId("util4"));
        ResourceLocation util5 = SkillNodeBuilder.vampire(util4, VampireSkills.half_invulnerable).build(consumer, this.modId("util5"));
        ResourceLocation util6 = SkillNodeBuilder.vampire(util5, VampireSkills.vampire_invisibility).build(consumer, this.modId("util6"));
        ResourceLocation offensive1 = SkillNodeBuilder.vampire(skill4, VampireSkills.vampire_rage).build(consumer, this.modId("offensive1"));
        ResourceLocation offensive2 = SkillNodeBuilder.vampire(offensive1, VampireSkills.advanced_biter).build(consumer, this.modId("offensive2"));
        ResourceLocation offensive3 = SkillNodeBuilder.vampire(offensive2, VampireSkills.sword_finisher).build(consumer, this.modId("offensive3"));
        ResourceLocation offensive4 = SkillNodeBuilder.vampire(offensive3, VampireSkills.dark_blood_projectile).build(consumer, this.modId("offensive4"));
        ResourceLocation offensive5 = SkillNodeBuilder.vampire(offensive4, VampireSkills.blood_charge).build(consumer, this.modId("offensive5"));
        ResourceLocation offensive6 = SkillNodeBuilder.vampire(offensive5, VampireSkills.freeze).build(consumer, this.modId("offensive6"));
        ResourceLocation defensive1 = SkillNodeBuilder.vampire(skill4, VampireSkills.sunscreen).build(consumer, this.modId("defensive1"));
        ResourceLocation defensive2 = SkillNodeBuilder.vampire(defensive1, VampireSkills.vampire_jump, VampireSkills.vampire_speed).build(consumer, this.modId("defensive2"));
        ResourceLocation defensive3 = SkillNodeBuilder.vampire(defensive2, VampireSkills.blood_vision).build(consumer, this.modId("defensive3"));
        ResourceLocation defensive4 = SkillNodeBuilder.vampire(defensive3, VampireSkills.creeper_avoided).build(consumer, this.modId("defensive4"));
        ResourceLocation defensive5 = SkillNodeBuilder.vampire(defensive4, VampireSkills.vampire_forest_fog, VampireSkills.blood_vision_garlic).build(consumer, this.modId("defensive5"));
        resourceLocation = SkillNodeBuilder.vampire(defensive5, VampireSkills.teleport).build(consumer, this.modId("defensive6"));
    }

    private ResourceLocation modId(String string) {
        return new ResourceLocation("vampirism", string);
    }
}

