/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.recipebuilder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.advancements.SkillUnlockedTrigger;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ShapedWeaponTableRecipeBuilder
extends ShapedRecipeBuilder {
    private int lava = 1;
    private ISkill[] skills;
    private int level = 1;
    private JsonObject extraNbt;

    public ShapedWeaponTableRecipeBuilder(IItemProvider item, int count, @Nullable JsonObject extraNbt) {
        super(item, count);
        this.extraNbt = extraNbt;
    }

    public static ShapedWeaponTableRecipeBuilder shapedWeaponTable(IItemProvider item) {
        return new ShapedWeaponTableRecipeBuilder(item, 1, null);
    }

    public static ShapedWeaponTableRecipeBuilder shapedWeaponTable(IItemProvider item, int count) {
        return new ShapedWeaponTableRecipeBuilder(item, count, null);
    }

    public static ShapedWeaponTableRecipeBuilder shapedWeaponTable(IItemProvider item, int count, JsonObject nbt) {
        return new ShapedWeaponTableRecipeBuilder(item, count, nbt);
    }

    public ShapedWeaponTableRecipeBuilder lava(int amount) {
        this.lava = amount;
        return this;
    }

    public ShapedWeaponTableRecipeBuilder skills(ISkill ... skills) {
        this.skills = skills;
        return this;
    }

    public ShapedWeaponTableRecipeBuilder level(int level) {
        this.level = level;
        return this;
    }

    public ShapedWeaponTableRecipeBuilder key(Character p_200469_1_, Tag<Item> p_200469_2_) {
        return (ShapedWeaponTableRecipeBuilder)super.func_200469_a(p_200469_1_, p_200469_2_);
    }

    public ShapedWeaponTableRecipeBuilder key(Character p_200462_1_, IItemProvider p_200462_2_) {
        return (ShapedWeaponTableRecipeBuilder)super.func_200462_a(p_200462_1_, p_200462_2_);
    }

    public ShapedWeaponTableRecipeBuilder key(Character p_200471_1_, Ingredient p_200471_2_) {
        return (ShapedWeaponTableRecipeBuilder)super.func_200471_a(p_200471_1_, p_200471_2_);
    }

    public ShapedWeaponTableRecipeBuilder patternLine(String p_200472_1_) {
        return (ShapedWeaponTableRecipeBuilder)super.func_200472_a(p_200472_1_);
    }

    public ShapedWeaponTableRecipeBuilder addCriterion(String p_200465_1_, ICriterionInstance p_200465_2_) {
        return (ShapedWeaponTableRecipeBuilder)super.func_200465_a(p_200465_1_, p_200465_2_);
    }

    public ShapedWeaponTableRecipeBuilder setGroup(String p_200473_1_) {
        return (ShapedWeaponTableRecipeBuilder)super.func_200473_b(p_200473_1_);
    }

    public void func_200467_a(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        id = new ResourceLocation(id.func_110624_b(), "weapontable/" + id.func_110623_a());
        this.field_200479_f.func_200275_a("has_skill", (ICriterionInstance)SkillUnlockedTrigger.builder(this.skills != null && this.skills.length >= 1 ? this.skills[0] : HunterSkills.weapon_table));
        this.func_200463_a(id);
        this.field_200479_f.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)new RecipeUnlockedTrigger.Instance(id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumer.accept((IFinishedRecipe)new Result(id, this.field_200475_b, this.field_200476_c, this.field_200480_g == null ? "" : this.field_200480_g, this.field_200477_d, this.field_200478_e, this.field_200479_f, new ResourceLocation(id.func_110624_b(), "recipes/" + this.field_200475_b.func_77640_w().func_200300_c() + "/" + id.func_110623_a()), this.lava, this.skills != null ? this.skills : new ISkill[]{}, this.level, this.extraNbt));
    }

    private class Result
    extends ShapedRecipeBuilder.Result {
        private final int lava;
        private final ISkill[] skills;
        private final int level;
        private final JsonObject extraNbt;

        public Result(ResourceLocation id, Item item, int count, String group, List<String> pattern, Map<Character, Ingredient> ingredients, Advancement.Builder advancementBuilder, ResourceLocation advancementId, int lava, ISkill[] skills, int level, JsonObject extraNbt) {
            super((ShapedRecipeBuilder)ShapedWeaponTableRecipeBuilder.this, id, item, count, group, pattern, ingredients, advancementBuilder, advancementId);
            this.lava = lava;
            this.skills = skills;
            this.level = level;
            this.extraNbt = extraNbt;
        }

        public void func_218610_a(JsonObject jsonObject) {
            super.func_218610_a(jsonObject);
            jsonObject.addProperty("lava", (Number)this.lava);
            JsonArray skills = new JsonArray();
            for (ISkill skill : this.skills) {
                skills.add(skill.getRegistryName().toString());
            }
            jsonObject.add("skill", (JsonElement)skills);
            jsonObject.addProperty("level", (Number)this.level);
            if (this.extraNbt != null) {
                jsonObject.get("result").getAsJsonObject().add("nbt", (JsonElement)this.extraNbt);
            }
        }

        @Nonnull
        public IRecipeSerializer<?> func_218609_c() {
            return ModRecipes.shaped_crafting_weapontable;
        }
    }
}

