/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.data.recipebuilder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.teamlapen.vampirism.advancements.SkillUnlockedTrigger;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.core.ModRecipes;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ShapelessWeaponTableRecipeBuilder
extends ShapelessRecipeBuilder {
    private int lava = 1;
    private ISkill[] skills;
    private int level = 1;

    public ShapelessWeaponTableRecipeBuilder(IItemProvider resultIn, int countIn) {
        super(resultIn, countIn);
    }

    public static ShapelessWeaponTableRecipeBuilder shapelessWeaponTable(IItemProvider result, int count) {
        return new ShapelessWeaponTableRecipeBuilder(result, count);
    }

    public static ShapelessWeaponTableRecipeBuilder shapelessWeaponTable(IItemProvider result) {
        return new ShapelessWeaponTableRecipeBuilder(result, 1);
    }

    public ShapelessWeaponTableRecipeBuilder lava(int amount) {
        this.lava = amount;
        return this;
    }

    public ShapelessWeaponTableRecipeBuilder skills(ISkill ... skills) {
        this.skills = skills;
        return this;
    }

    public ShapelessWeaponTableRecipeBuilder level(int level) {
        this.level = level;
        return this;
    }

    public ShapelessWeaponTableRecipeBuilder addIngredient(Tag<Item> tagIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.func_203221_a(tagIn);
    }

    public ShapelessWeaponTableRecipeBuilder addIngredient(IItemProvider itemIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.func_200487_b(itemIn);
    }

    public ShapelessWeaponTableRecipeBuilder addIngredient(IItemProvider itemIn, int quantity) {
        return (ShapelessWeaponTableRecipeBuilder)super.func_200491_b(itemIn, quantity);
    }

    public ShapelessWeaponTableRecipeBuilder addIngredient(Ingredient ingredientIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.func_200489_a(ingredientIn);
    }

    public ShapelessWeaponTableRecipeBuilder addIngredient(Ingredient ingredientIn, int quantity) {
        return (ShapelessWeaponTableRecipeBuilder)super.func_200492_a(ingredientIn, quantity);
    }

    public ShapelessWeaponTableRecipeBuilder addCriterion(String name, ICriterionInstance criterionIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.func_200483_a(name, criterionIn);
    }

    public ShapelessWeaponTableRecipeBuilder setGroup(String groupIn) {
        return (ShapelessWeaponTableRecipeBuilder)super.func_200490_a(groupIn);
    }

    public void func_200485_a(Consumer<IFinishedRecipe> consumerIn, ResourceLocation id) {
        id = new ResourceLocation(id.func_110624_b(), "weapontable/" + id.func_110623_a());
        this.field_200497_e.func_200275_a("has_skill", (ICriterionInstance)SkillUnlockedTrigger.builder(this.skills != null && this.skills.length >= 1 ? this.skills[0] : HunterSkills.weapon_table));
        this.func_200481_a(id);
        this.field_200497_e.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)new RecipeUnlockedTrigger.Instance(id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumerIn.accept((IFinishedRecipe)new Result(id, this.field_200494_b, this.field_200495_c, this.field_200498_f == null ? "" : this.field_200498_f, this.field_200496_d, this.field_200497_e, new ResourceLocation(id.func_110624_b(), "recipes/" + this.field_200494_b.func_77640_w().func_200300_c() + "/" + id.func_110623_a()), this.lava, this.skills != null ? this.skills : new ISkill[]{}, this.level));
    }

    private class Result
    extends ShapelessRecipeBuilder.Result {
        private final int lava;
        private final ISkill[] skills;
        private final int level;

        public Result(ResourceLocation idIn, Item resultIn, int countIn, String groupIn, List<Ingredient> ingredientsIn, Advancement.Builder advancementBuilderIn, ResourceLocation advancementIdIn, int lavaIn, ISkill[] skillsIn, int levelIn) {
            super(idIn, resultIn, countIn, groupIn, ingredientsIn, advancementBuilderIn, advancementIdIn);
            this.lava = lavaIn;
            this.skills = skillsIn;
            this.level = levelIn;
        }

        public void func_218610_a(JsonObject json) {
            super.func_218610_a(json);
            json.addProperty("lava", (Number)this.lava);
            JsonArray skills = new JsonArray();
            for (ISkill skill : this.skills) {
                skills.add(skill.getRegistryName().toString());
            }
            json.add("skill", (JsonElement)skills);
            json.addProperty("level", (Number)this.level);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return ModRecipes.shapeless_crafting_weapontable;
        }
    }
}

