/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.IEntityWithHome;
import de.teamlapen.vampirism.api.entity.IVampirismEntity;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.particle.GenericParticleData;
import de.teamlapen.vampirism.tileentity.TotemHelper;
import de.teamlapen.vampirism.world.gen.biome.VampireBiome;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public abstract class VampirismEntity
extends CreatureEntity
implements IEntityWithHome,
IVampirismEntity {
    private final Goal moveTowardsRestriction = new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0);
    protected boolean hasArms = true;
    protected boolean peaceful = false;
    protected boolean saveHome = false;
    @Nullable
    private AxisAlignedBB home;
    private boolean moveTowardsRestrictionAdded = false;
    private int moveTowardsRestrictionPrio = -1;
    private int randomTickDivider;
    private boolean doImobConversion = false;

    public static boolean spawnPredicateLight(IWorld world, BlockPos blockPos, Random random) {
        if (world.func_226658_a_(LightType.SKY, blockPos) > random.nextInt(32)) {
            return false;
        }
        int lvt_3_1_ = world.func_201672_e().func_72911_I() ? world.func_205049_d(blockPos, 10) : world.func_201696_r(blockPos);
        return lvt_3_1_ <= random.nextInt(8);
    }

    public static boolean spawnPredicateVampireFog(IWorld world, BlockPos blockPos) {
        return world.func_226691_t_(blockPos) instanceof VampireBiome || TotemHelper.isInsideVampireAreaCached(world.func_201675_m(), blockPos);
    }

    public static boolean spawnPredicateCanSpawn(EntityType<? extends MobEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        BlockPos blockpos = blockPos.func_177977_b();
        return spawnReason == SpawnReason.SPAWNER || world.func_180495_p(blockpos).func_215688_a((IBlockReader)world, blockpos, entityType);
    }

    public VampirismEntity(EntityType<? extends VampirismEntity> type, World world) {
        super(type, world);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return (this.peaceful || worldIn.func_175659_aa() != Difficulty.PEACEFUL) && super.func_213380_a(worldIn, spawnReasonIn);
    }

    @Override
    @Nullable
    public AxisAlignedBB getHome() {
        return this.home;
    }

    @Override
    public void setHome(@Nullable AxisAlignedBB home) {
        this.home = home;
        if (home != null) {
            int posX = (int)(home.field_72340_a + (home.field_72336_d - home.field_72340_a) / 2.0);
            int posY = (int)(home.field_72338_b + (home.field_72337_e - home.field_72338_b) / 2.0);
            int posZ = (int)(home.field_72339_c + (home.field_72334_f - home.field_72339_c) / 2.0);
            super.func_213390_a(new BlockPos(posX, posY, posZ), (int)home.func_72320_b());
        } else {
            super.func_213390_a(new BlockPos(0, 0, 0), -1);
        }
    }

    @Override
    public boolean isWithinHomeDistance(double x, double y, double z) {
        if (this.home != null) {
            return this.home.func_72318_a(new Vec3d(x, y, z));
        }
        return true;
    }

    public boolean func_213383_dH() {
        return this.isWithinHomeDistance(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    public boolean func_213389_a(BlockPos pos) {
        return this.isWithinHomeDistance(pos);
    }

    public void func_70636_d() {
        if (this.hasArms) {
            this.func_82168_bl();
        }
        super.func_70636_d();
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("home")) {
            this.saveHome = true;
            int[] h = nbt.func_74759_k("home");
            this.setHome(new AxisAlignedBB((double)h[0], (double)h[1], (double)h[2], (double)h[3], (double)h[4], (double)h[5]));
            if (nbt.func_74764_b("homeMovePrio")) {
                this.setMoveTowardsRestriction(nbt.func_74762_e("moveHomePrio"), true);
            }
        }
    }

    @Override
    public void setHomeArea(BlockPos pos, int r) {
        this.setHome(new AxisAlignedBB(pos.func_177982_a(-r, -r, -r), pos.func_177982_a(r, r, r)));
    }

    public void func_213390_a(BlockPos pos, int distance) {
        this.setHomeArea(pos, distance);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.checkImobConversion();
        if (!this.field_70170_p.field_72995_K && !this.peaceful && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        if (this.saveHome && this.home != null) {
            int[] h = new int[]{(int)this.home.field_72340_a, (int)this.home.field_72338_b, (int)this.home.field_72339_c, (int)this.home.field_72336_d, (int)this.home.field_72337_e, (int)this.home.field_72334_f};
            nbt.func_74783_a("home", h);
            if (this.moveTowardsRestrictionAdded && this.moveTowardsRestrictionPrio > -1) {
                nbt.func_74768_a("homeMovePrio", this.moveTowardsRestrictionPrio);
            }
        }
    }

    protected boolean func_146066_aG() {
        return true;
    }

    protected void disableMoveTowardsRestriction() {
        if (this.moveTowardsRestrictionAdded) {
            this.field_70714_bg.func_85156_a(this.moveTowardsRestriction);
            this.moveTowardsRestrictionAdded = false;
        }
    }

    protected void enableImobConversion() {
        if (!(this instanceof IFactionEntity)) {
            throw new IllegalStateException("Can only do IMob conversion for IFactionEntity");
        }
        this.doImobConversion = true;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187738_cy;
    }

    protected SoundEvent func_184588_d(int heightIn) {
        return heightIn > 4 ? SoundEvents.field_187735_cx : SoundEvents.field_187589_cA;
    }

    protected SoundEvent getHurtSound() {
        return SoundEvents.field_187741_cz;
    }

    protected EntityType<?> getIMobTypeOpt(boolean iMob) {
        return this.func_200600_R();
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187591_cB;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected boolean isLowLightLevel(IWorld iWorld) {
        BlockPos blockpos = new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72338_b, this.func_226281_cx_());
        if (iWorld.func_226658_a_(LightType.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int i = iWorld.func_201696_r(blockpos);
        if (iWorld instanceof World && ((World)iWorld).func_72911_I()) {
            i = iWorld.func_201696_r(blockpos);
        }
        return i <= this.field_70146_Z.nextInt(8);
    }

    protected void onRandomTick() {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    protected void setDontDropEquipment() {
        Arrays.fill(this.field_184655_bs, 0.0f);
        Arrays.fill(this.field_82174_bp, 0.0f);
    }

    protected void setMoveTowardsRestriction(int prio, boolean active) {
        if (this.moveTowardsRestrictionAdded) {
            if (active && this.moveTowardsRestrictionPrio == prio) {
                return;
            }
            this.field_70714_bg.func_85156_a(this.moveTowardsRestriction);
            this.moveTowardsRestrictionAdded = false;
        }
        if (active) {
            this.field_70714_bg.func_75776_a(prio, this.moveTowardsRestriction);
            this.moveTowardsRestrictionAdded = true;
            this.moveTowardsRestrictionPrio = prio;
        }
    }

    protected void teleportAway() {
        this.func_82142_c(true);
        ModParticles.spawnParticlesServer(this.field_70170_p, new GenericParticleData(ModParticles.generic, new ResourceLocation("minecraft", "effect_6"), 10, 657930, 0.6f), this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 20, 1.0, 1.0, 1.0, 0.0);
        this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        this.func_70106_y();
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (--this.randomTickDivider <= 0) {
            this.randomTickDivider = 70 + this.field_70146_Z.nextInt(50);
            this.onRandomTick();
        }
    }

    private void checkImobConversion() {
        if (this.doImobConversion && !this.field_70170_p.field_72995_K && this.field_70173_aa % 256 == 0) {
            boolean current = this instanceof IMob;
            boolean convert = false;
            VampirismConfig.Server.IMobOptions opt = (VampirismConfig.Server.IMobOptions)((Object)VampirismConfig.SERVER.entityIMob.get());
            if (ServerLifecycleHooks.getCurrentServer().func_71262_S()) {
                convert = opt == VampirismConfig.Server.IMobOptions.ALWAYS_IMOB != current;
            } else if (opt == VampirismConfig.Server.IMobOptions.SMART) {
                PlayerEntity player = VampirismMod.proxy.getClientPlayer();
                if (player != null && player.func_70089_S()) {
                    IPlayableFaction<? extends IFactionPlayer<?>> f = FactionPlayerHandler.get(player).getCurrentFaction();
                    IFaction thisFaction = ((IFactionEntity)((Object)this)).getFaction();
                    boolean hostile = f == null ? thisFaction.isHostileTowardsNeutral() : !thisFaction.equals(f);
                    convert = hostile != current;
                }
            } else {
                boolean bl = convert = opt == VampirismConfig.Server.IMobOptions.ALWAYS_IMOB != current;
            }
            if (convert) {
                EntityType<?> t = this.getIMobTypeOpt(!current);
                Entity newEntity = t.func_200721_a(this.field_70170_p);
                CompoundNBT nbt = new CompoundNBT();
                this.func_189511_e(nbt);
                newEntity.func_70020_e(nbt);
                newEntity.func_184221_a(MathHelper.func_180182_a((Random)this.field_70146_Z));
                this.func_70106_y();
                this.field_70170_p.func_217376_c(newEntity);
            }
        }
    }
}

