/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.command.arguments.EntityOptions;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VampirismEntitySelectors {
    private static final Logger LOGGER = LogManager.getLogger(VampirismEntitySelectors.class);
    private static final String FACTION = "vampirism:faction";
    private static final String LEVEL = "vampirism:level";
    private static final String MIN_LEVEL = "vampirism:minLevel";
    private static final String MAX_LEVEL = "vampirism:maxLevel";
    private static final DynamicCommandExceptionType FACTION_NOT_FOUND = new DynamicCommandExceptionType(p_208726_0_ -> new TranslationTextComponent("vampirism.argument.entity.options.faction.not_found", new Object[]{p_208726_0_}));

    public static void registerSelectors() {
        EntityOptions.func_202024_a((String)FACTION, parser -> {
            IFaction[] factions;
            boolean invert = parser.func_197378_e();
            ResourceLocation factionID = new ResourceLocation(parser.func_197398_f().readString());
            for (IFaction f : factions = VampirismAPI.factionRegistry().getFactions()) {
                if (!f.getID().equals((Object)factionID)) continue;
                parser.func_197401_a(input -> {
                    if (input instanceof IFactionEntity) {
                        boolean flag1 = f.equals(((IFactionEntity)input).getFaction());
                        return invert != flag1;
                    }
                    if (f instanceof IPlayableFaction && input instanceof PlayerEntity) {
                        boolean flag1 = (Boolean)FactionPlayerHandler.getOpt((PlayerEntity)input).map(h -> h.isInFaction((IPlayableFaction)f)).orElse((Object)false);
                        return invert != flag1;
                    }
                    return invert;
                });
                return;
            }
            throw FACTION_NOT_FOUND.createWithContext((ImmutableStringReader)parser.func_197398_f(), (Object)factionID);
        }, parser -> true, (ITextComponent)new TranslationTextComponent("vampirism.argument.entity.options.faction.desc", new Object[0]));
        EntityOptions.func_202024_a((String)LEVEL, parser -> {
            StringReader reader = parser.func_197398_f();
            MinMaxBounds.IntBound bound = MinMaxBounds.IntBound.func_211342_a((StringReader)reader);
            if (bound.func_196973_a() != null && (Integer)bound.func_196973_a() < 0 || bound.func_196977_b() != null && (Integer)bound.func_196977_b() < 0) {
                throw EntityOptions.field_197471_d.createWithContext((ImmutableStringReader)reader);
            }
            parser.func_197401_a(input -> {
                if (input instanceof PlayerEntity) {
                    int level = (Integer)FactionPlayerHandler.getOpt((PlayerEntity)input).map(FactionPlayerHandler::getCurrentLevel).orElse((Object)0);
                    return !(bound.func_196973_a() != null && (Integer)bound.func_196973_a() > level || bound.func_196977_b() != null && (Integer)bound.func_196977_b() < level);
                }
                return false;
            });
        }, parser -> true, (ITextComponent)new TranslationTextComponent("vampirism.argument.entity.options.level.desc", new Object[0]));
    }
}

