/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.action;

import com.google.common.collect.Lists;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.actions.EntityActionEntry;
import de.teamlapen.vampirism.api.entity.actions.IActionHandlerEntity;
import de.teamlapen.vampirism.api.entity.actions.IEntityAction;
import de.teamlapen.vampirism.api.entity.actions.IEntityActionUser;
import de.teamlapen.vampirism.api.entity.actions.IInstantAction;
import de.teamlapen.vampirism.api.entity.actions.ILastingAction;
import de.teamlapen.vampirism.config.VampirismConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;

public class ActionHandlerEntity<T extends CreatureEntity>
implements IActionHandlerEntity {
    private T entity;
    private List<IEntityAction> availableActions;
    private int preActivation = 0;
    private int cooldown = 0;
    private int duration = 0;
    private float minimumHealthThreshold;
    @Nullable
    private IEntityAction action;
    private boolean isPlayerTarget;

    public ActionHandlerEntity(T entityIn) {
        this.entity = entityIn;
        this.availableActions = ((IEntityActionUser)entityIn).getAvailableActions();
    }

    @Nullable
    public IEntityAction getAction() {
        return this.action;
    }

    public void handle() {
        if (!((CreatureEntity)this.entity).field_70170_p.field_72995_K && this.availableActions != null && !this.availableActions.isEmpty()) {
            if (this.entity.func_70638_az() instanceof PlayerEntity) {
                if (this.isPlayerTarget) {
                    this.updateHandler();
                } else {
                    this.startExecuting();
                    this.isPlayerTarget = true;
                }
            } else if (this.isPlayerTarget) {
                this.isPlayerTarget = false;
                this.deactivateAction();
            }
        }
    }

    public boolean isPlayerTarget() {
        return this.isPlayerTarget;
    }

    public void read(CompoundNBT nbt) {
        if (nbt.func_74764_b("activeAction")) {
            this.deactivateAction((IEntityAction)VampirismAPI.entityActionManager().getRegistry().getValue(new ResourceLocation(nbt.func_74779_i("activeAction"))));
            this.isPlayerTarget = true;
        }
    }

    public void startExecuting() {
        this.action = null;
        this.cooldown = 50;
        this.duration = -1;
        this.preActivation = -1;
    }

    @Override
    public boolean isActionActive(IEntityAction action) {
        return this.action != null && this.action.equals(action) && this.duration > 0;
    }

    private void activateAction() {
        if (this.action instanceof ILastingAction) {
            ((ILastingAction)this.action).activate(this.entity);
        } else if (this.action instanceof IInstantAction) {
            ((IInstantAction)this.action).activate(this.entity);
        }
    }

    private void cancelActivation() {
        this.preActivation = -1;
        this.duration = -1;
        this.cooldown = 100;
    }

    @Nullable
    private IEntityAction chooseNewAction() {
        ArrayList entry = Lists.newArrayList();
        int weightsum = 0;
        for (IEntityAction e : this.availableActions) {
            int weight = e.getWeight((CreatureEntity)this.entity);
            if (weight <= 0) continue;
            entry.add(new EntityActionEntry(weight, e));
            weightsum += weight;
        }
        if (weightsum > 0) {
            return ((EntityActionEntry)WeightedRandom.func_76273_a((Random)this.entity.func_70681_au(), (List)entry, (int)weightsum)).getAction();
        }
        return null;
    }

    @Override
    public void deactivateAction() {
        this.deactivateAction(null);
    }

    private void deactivateAction(@Nullable IEntityAction actionIn) {
        IEntityAction action;
        IEntityAction iEntityAction = action = actionIn != null ? actionIn : this.action;
        if (action instanceof ILastingAction) {
            ((ILastingAction)action).deactivate(this.entity);
        }
    }

    private void updateAction() {
        if (this.action instanceof ILastingAction) {
            ((ILastingAction)this.action).onUpdate(this.entity, this.duration);
        }
    }

    private void updateHandler() {
        if (this.preActivation == 0) {
            this.activateAction();
            --this.preActivation;
        } else if (this.preActivation > 0) {
            this.updatePreAction();
            --this.preActivation;
            if (this.entity.func_110143_aJ() < this.minimumHealthThreshold) {
                this.cancelActivation();
            }
        } else if (this.duration == 0) {
            this.deactivateAction();
            --this.duration;
        } else if (this.duration > 0) {
            --this.duration;
            this.updateAction();
        } else if (this.cooldown > 0) {
            --this.cooldown;
        } else {
            this.action = this.chooseNewAction();
            if (this.action == null) {
                this.cancelActivation();
                return;
            }
            this.cooldown = this.action.getCooldown(((IAdjustableLevel)this.entity).getLevel());
            this.preActivation = this.action.getPreActivationTime();
            this.minimumHealthThreshold = (float)((double)this.entity.func_110143_aJ() - (double)this.entity.func_110138_aP() * (Double)VampirismConfig.BALANCE.eaHealthThreshold.get());
            if (this.action instanceof ILastingAction) {
                this.duration = ((ILastingAction)this.action).getDuration(((IAdjustableLevel)this.entity).getLevel());
            }
        }
    }

    private void updatePreAction() {
        if (this.action instanceof ILastingAction) {
            ((ILastingAction)this.action).updatePreAction(this.entity, this.preActivation);
        } else if (this.action instanceof IInstantAction) {
            ((IInstantAction)this.action).updatePreAction(this.entity, this.preActivation);
        }
    }

    public void write(CompoundNBT nbt) {
        if (this.isPlayerTarget() && this.action != null) {
            nbt.func_74778_a("activeAction", this.action.getRegistryName().toString());
        }
    }
}

