/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.action.vampire;

import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import de.teamlapen.vampirism.api.entity.EntityClassType;
import de.teamlapen.vampirism.api.entity.actions.EntityActionTier;
import de.teamlapen.vampirism.api.entity.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.VampirismConfig;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.entity.action.vampire.VampireEntityAction;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.IWorld;

public class IgnoreSunDamageEntityAction<T extends CreatureEntity>
extends VampireEntityAction<T>
implements ILastingAction<T> {
    public IgnoreSunDamageEntityAction(EntityActionTier tier, EntityClassType ... param) {
        super(tier, param);
    }

    @Override
    public void activate(T entity) {
        entity.func_195064_c(new EffectInstance(ModEffects.sunscreen, this.getDuration(((IAdjustableLevel)entity).getLevel()), 0));
    }

    @Override
    public void deactivate(T entity) {
        if (entity.func_70660_b(ModEffects.sunscreen) != null && entity.func_70660_b(ModEffects.sunscreen).func_76458_c() == 0) {
            entity.func_195063_d(ModEffects.sunscreen);
        }
    }

    @Override
    public int getCooldown(int level) {
        return (Integer)VampirismConfig.BALANCE.eaIgnoreSundamageCooldown.get() * 20;
    }

    @Override
    public int getDuration(int level) {
        return (Integer)VampirismConfig.BALANCE.eaIgnoreSundamageDuration.get() * 20;
    }

    @Override
    public int getWeight(CreatureEntity entity) {
        if (!entity.func_130014_f_().func_72935_r() || entity.func_130014_f_().func_72896_J()) {
            return 0;
        }
        return ((IVampire)entity).isGettingSundamage((IWorld)entity.field_70170_p) ? 3 : 1;
    }

    @Override
    public void onUpdate(T entity, int duration) {
    }
}

